/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.BuildStatusDialog;
import com.atlassian.webdriver.bitbucket.element.Participant;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.By;

public class PullRequestTable
extends AbstractElementPageObject {
    public PullRequestTable(PageElement pageElement) {
        super(pageElement);
    }

    public Iterable<String> getColumnNames() {
        return Iterables.transform(this.findAll(By.tagName((String)"th")), PageElement::getText);
    }

    public String getCurrentTimestamp() {
        return this.container.getAttribute("data-last-updated");
    }

    public List<Entry> getRows() {
        return Lists.transform((List)this.container.findAll(Locators.tableRow()), ElementUtils.bind(this.pageBinder, Entry.class, new Object[0])::apply);
    }

    public void loadNextPage() {
        ElementUtils.scrollDocumentAndWait(this.container);
    }

    public void waitUntilTableIsUpdated(String currentTimestamp) {
        Poller.waitUntilFalse((TimedQuery)this.container.timed().hasAttribute("data-last-updated", currentTimestamp));
    }

    public static class Entry
    extends AbstractElementPageObject {
        public Entry(PageElement pageElement) {
            super(pageElement);
        }

        public String getAuthorName() {
            return this.getAuthorElement().getText();
        }

        public String getAuthorUsername() {
            return this.getAuthorElement().find(By.cssSelector((String)"span.user-avatar")).getAttribute("data-username");
        }

        public BuildStatusDialog getBuildStatusDialog() {
            Poller.waitUntilTrue((TimedQuery)this.container.find(By.cssSelector((String)"td.build-status-pr-list-col-value > a")).timed().isPresent());
            this.container.find(By.cssSelector((String)"td.build-status-pr-list-col-value > a")).click();
            return (BuildStatusDialog)((Object)this.pageBinder.bind(BuildStatusDialog.class, new Object[]{By.id((String)"build-status-dialog"), TimeoutType.DIALOG_LOAD}));
        }

        public long getId() {
            return Long.parseLong(this.container.getAttribute("data-pull-request-id"));
        }

        public int getOpenTaskCount() {
            PageElement count = this.container.find(By.cssSelector((String)"td.count-column-value > span.pr-list-open-task-count > span.task-count"));
            return count.isPresent() ? Integer.parseInt(count.getText()) : 0;
        }

        public List<Participant> getReviewers() {
            return this.container.findAll(By.cssSelector((String)"td.reviewers > .user-avatar"), Participant.class);
        }

        public String getTitle() {
            return this.find(By.cssSelector((String)"td.title > div.title-and-target-branch > a.pull-request-title")).getText();
        }

        public boolean hasBuildStatus() {
            Poller.waitUntilTrue((TimedQuery)this.container.find(By.cssSelector((String)"td.build-status-pr-list-col-value")).timed().isPresent());
            return this.container.find(By.cssSelector((String)"td.build-status-pr-list-col-value > a")).isPresent();
        }

        private PageElement getAuthorElement() {
            return this.find(By.cssSelector((String)"td.title > div.author-and-timestamp > div.avatar-with-name"));
        }
    }
}

