/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import java.util.EnumSet;

public enum PermissionKind {
    LICENSED_USER(true),
    PROJECT_CREATE(true),
    ADMIN(true),
    SYS_ADMIN(true),
    PROJECT_READ(false),
    PROJECT_WRITE(false),
    PROJECT_ADMIN(false),
    REPO_READ(false),
    REPO_WRITE(false),
    REPO_ADMIN(false);

    private final boolean global;

    private PermissionKind(boolean global) {
        this.global = global;
    }

    public static Iterable<PermissionKind> globals() {
        EnumSet<PermissionKind> permissions = EnumSet.noneOf(PermissionKind.class);
        for (PermissionKind permission : PermissionKind.values()) {
            if (!permission.global) continue;
            permissions.add(permission);
        }
        return permissions;
    }
}

