/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Comment;
import com.atlassian.webdriver.bitbucket.element.JsSpinner;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.Spinner;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;

public abstract class CommentForm<T extends CommentForm<T>>
extends LegacyElementPageObject {
    @Inject
    protected PageElementFinder elementFinder;

    public CommentForm(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public CommentForm(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public void attach(String attachmentFilePath) {
        ElementUtils.waitUntilValueUpdated(this.getTextArea(), () -> {
            PageElement input = this.find(By.cssSelector((String)".markup-toolbar input[type=file]"));
            ElementUtils.uploadFile(input, attachmentFilePath);
        });
    }

    public void cancel() {
        this.getCancelLink().click();
    }

    public String getText() {
        return this.getTextArea().getValue();
    }

    @Deprecated
    public String getPreviewContent() {
        return ElementUtils.getHtml(this.getPreviewArea());
    }

    public boolean hasErrors() {
        return this.find(By.className((String)"error")).isPresent();
    }

    @Deprecated
    public boolean isPreviewVisible() {
        return this.getPreviewArea().isVisible();
    }

    public T setText(String text) {
        this.getTextArea().click().clear().type(new CharSequence[]{text});
        return (T)((Object)this);
    }

    public abstract Comment submit();

    public void togglePreview() {
        Poller.waitUntilTrue((TimedQuery)this.getPreviewButton().timed().isVisible());
        boolean visible = this.getPreviewArea().isVisible();
        this.getPreviewButton().click();
        Poller.waitUntilEquals((Object)(!visible ? 1 : 0), (TimedQuery)this.getPreviewArea().timed().isVisible());
    }

    protected static List<Long> toIdList(List<Comment> comments) {
        return Lists.transform(comments, Comment::getCommentId);
    }

    protected PageElement getCancelLink() {
        return this.find(By.cssSelector((String)".cancel"));
    }

    protected PageElement getCommentButton() {
        return this.find(By.cssSelector((String)".buttons > button"));
    }

    @Deprecated
    public PageElement getPreviewArea() {
        return this.find(By.className((String)"markup-preview"));
    }

    protected PageElement getPreviewButton() {
        return this.find(By.className((String)"markup-preview-button"));
    }

    protected Spinner getSpinner() {
        return (Spinner)this.find(By.cssSelector((String)".buttons > .spinner"), JsSpinner.class);
    }

    protected PageElement getTextArea() {
        return this.find(By.tagName((String)"textarea"));
    }
}

