/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.setup;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.setup.SetupPage;
import org.apache.commons.lang.StringUtils;

public class MirrorSetupPage
extends SetupPage {
    @ElementBy(id="baseUrl")
    private PageElement mirrorBaseUrl;
    @ElementBy(id="applicationTitle")
    private PageElement mirrorName;
    @ElementBy(id="upstreamUrl")
    private PageElement primaryServerUrl;
    @ElementBy(id="upstream-cloud")
    private PageElement primaryCloud;
    @ElementBy(id="upstream-server")
    private PageElement primaryServer;
    @ElementBy(id="submit")
    private PageElement submitButton;

    @Override
    public String getStepHeading() {
        return "Configure mirror settings";
    }

    public String getMirrorBaseUrl() {
        return this.mirrorBaseUrl.getValue();
    }

    public String getMirrorName() {
        return this.mirrorName.getValue();
    }

    public String getPrimaryServerUrl() {
        return this.primaryServerUrl.getValue();
    }

    public boolean hasMirrorBaseUrlWarning() {
        return this.hasError(this.mirrorBaseUrl);
    }

    public boolean hasMirrorNameWarning() {
        return this.hasError(this.mirrorName);
    }

    public boolean hasPrimaryServerUrlWarning() {
        return this.hasError(this.primaryServerUrl);
    }

    public boolean isPrimaryCloud() {
        return this.primaryCloud.isSelected();
    }

    public boolean isPrimaryServer() {
        return this.primaryServer.isSelected();
    }

    public boolean isPrimaryServerUrlVisible() {
        return this.primaryServerUrl.isVisible();
    }

    public void setMirrorBaseUrl(String value) {
        this.mirrorBaseUrl.clear().type(new CharSequence[]{value});
    }

    public void setMirrorName(String value) {
        this.mirrorName.clear().type(new CharSequence[]{value});
    }

    public void setPrimaryServerUrl(String value) {
        this.primaryServerUrl.clear().type(new CharSequence[]{value});
    }

    public void setPrimaryToCloud() {
        this.primaryCloud.click();
    }

    public void setPrimaryToServer() {
        this.primaryServer.click();
    }

    public void clickSubmit() {
        this.submitButton.click();
    }

    private boolean hasError(PageElement inputElement) {
        String error = inputElement.getAttribute("data-aui-notification-error");
        return StringUtils.isNotBlank((String)error);
    }
}

