/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import org.openqa.selenium.By;

public class UserAccountNotificationSettingsPage
extends BitbucketPage {
    private static final String NOTIFICATION_SEND_MODE_ID = "notification-send-mode";
    @ElementBy(className="notification-settings-form")
    private PageElement settingsForm;

    public String getUrl() {
        return "/plugins/servlet/notification/settings";
    }

    public String getSelectedSendMode() {
        PageElement selectedMode = this.settingsForm.find(By.cssSelector((String)"input:checked"));
        return selectedMode.getAttribute("value");
    }

    public void save() {
        this.settingsForm.find(By.className((String)"save")).click();
    }

    public UserAccountNotificationSettingsPage setSelectedSendMode(String newMode) {
        PageElement mode = this.settingsForm.find(By.id((String)("setting-" + newMode.toLowerCase())));
        if (mode == null) {
            throw new IllegalArgumentException("Option for mode " + newMode + " does not exist!");
        }
        mode.select();
        return this;
    }
}

