/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.CodeMirrorSourceFileContent;
import com.atlassian.webdriver.bitbucket.element.EditFileFooter;
import com.atlassian.webdriver.bitbucket.element.LegacySourceFileContent;
import com.atlassian.webdriver.bitbucket.element.SourceFileContent;
import com.atlassian.webdriver.bitbucket.page.FileContentPage;
import com.atlassian.webdriver.bitbucket.page.FileLayoutPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.openqa.selenium.By;

public class FileSourcePage
extends FileContentPage<SourceFileContent> {
    @ElementBy(className="file-blame")
    private PageElement blameButton;
    @ElementBy(className="source-view", pageElementClass=CodeMirrorSourceFileContent.class)
    private CodeMirrorSourceFileContent codemirrorFileContent;
    private Boolean isLegacy;
    @ElementBy(className="source-view", pageElementClass=LegacySourceFileContent.class)
    private LegacySourceFileContent legacyFileContent;
    @ElementBy(className="raw-view-link")
    private PageElement rawLink;

    public FileSourcePage(String projectKey, String repoSlug, String path) {
        super(projectKey, repoSlug, path);
    }

    public FileSourcePage(String projectKey, String repoSlug, String path, String commitId) {
        super(projectKey, repoSlug, path, new FileLayoutPage.RevisionSpecifier(commitId, null));
    }

    public FileSourcePage(String projectKey, String repoSlug, String path, FileLayoutPage.RevisionSpecifier revisionSpecifier) {
        super(projectKey, repoSlug, path, revisionSpecifier);
    }

    public PageElement getEditButton() {
        this.getFileContent().waitUntilFileContentLoaded();
        return this.elementFinder.find(By.className((String)"in-browser-edit-button"));
    }

    public EditFileFooter getEditFooter() {
        return (EditFileFooter)this.pageBinder.bind(EditFileFooter.class, new Object[]{this.elementFinder.find(By.className((String)"edit-footer"))});
    }

    public PageElement getEditHeader() {
        return this.elementFinder.find(By.className((String)"edit-header"));
    }

    @Override
    public SourceFileContent getFileContent() {
        return this.codemirrorFileContent;
    }

    public String getRawLink() {
        this.getFileContent().waitUntilFileContentLoaded();
        return this.rawLink.getAttribute("href");
    }

    public PageElement getShowSourceButton() {
        return this.elementFinder.find(By.className((String)"use-default-handlers-button"));
    }

    public Collection<String> getWarningMessages() {
        return ElementUtils.getElementTexts(this.getFileContent().findAll(By.className((String)"aui-message-warning")));
    }

    public TimedCondition hasMultipleEditHeaders() {
        return Conditions.forSupplier(() -> this.elementFinder.findAll(By.className((String)"edit-header")).size() > 1);
    }

    public TimedCondition isInEditMode() {
        return this.elementFinder.find(By.className((String)"editing")).timed().isPresent();
    }

    public TimedCondition isShowingBlame() {
        return this.elementFinder.find(By.cssSelector((String)".blame[data-span]")).timed().isVisible();
    }

    public FileSourcePage loadUntilRevision(String revisionId) {
        return this.loadRevision(revisionId, FileSourcePage.class);
    }

    public List<BlameRow> showBlame() {
        this.getFileContent().waitUntilFileContentLoaded();
        this.waitUntilEventFired("bitbucket.internal.feature.fileContent.fileBlameExpandedStateChanged", () -> this.blameButton.click());
        return this.getBlame(By.cssSelector((String)".blame[data-span]"), CodeMirrorBlameRow.class);
    }

    @Override
    protected String getPathComponent() {
        return "browse";
    }

    private <T extends BlameRow> List<BlameRow> getBlame(By locator, Class<T> clazz) {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(locator).timed().isPresent());
        return Lists.transform((List)this.elementFinder.findAll(locator), element -> (BlameRow)this.pageBinder.bind(clazz, new Object[]{element}));
    }

    public static class CodeMirrorBlameRow
    implements BlameRow {
        private final PageElement firstLine;

        public CodeMirrorBlameRow(PageElement firstLine) {
            this.firstLine = firstLine;
        }

        @Override
        public String getAuthor() {
            return this.firstLine.find(By.className((String)"blame-author")).getAttribute("title");
        }

        @Override
        public String getCommit() {
            return ElementUtils.scrollIntoViewIfNeeded(this.firstLine).find(By.className((String)"commitid")).getText();
        }

        @Override
        public String getDate() {
            return ElementUtils.scrollIntoViewIfNeeded(this.firstLine).find(By.className((String)"blame-timestamp")).getText();
        }

        @Override
        public int getSpan() {
            return Integer.parseInt(this.firstLine.getAttribute("data-span"));
        }
    }

    public static interface BlameRow {
        public String getAuthor();

        public String getCommit();

        public String getDate();

        public int getSpan();
    }
}

