/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.IdOption;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.By;

public class UserOption
extends IdOption {
    public static final Function<UserOption, String> TO_DISPLAY_NAME = UserOption::getDisplayName;
    public static final Function<UserOption, String> TO_USERNAME = UserOption::getUsername;

    public UserOption(PageElement container) {
        super(container);
    }

    @Nonnull
    public static Predicate<UserOption> usernameMatches(@Nonnull String username) {
        return UserOption.idMatches(UserOption.class, username);
    }

    @Nullable
    public String getAvatarUrl() {
        return this.container.find(By.cssSelector((String)".aui-avatar-inner img")).getAttribute("src");
    }

    @Nullable
    public String getDisplayName() {
        return this.container.find(By.className((String)"avatar-with-name")).getAttribute("title");
    }

    @Override
    @Nullable
    public String getId() {
        return this.getUsername();
    }

    @Nullable
    public String getUsername() {
        return this.getUsernameContainer().getAttribute("data-username");
    }

    @Nonnull
    protected PageElement getUsernameContainer() {
        return this.container.find(By.className((String)"user-avatar"));
    }

    @Override
    protected void extendToString(Objects.ToStringHelper toStringHelper) {
        toStringHelper.add("username", (Object)this.getUsername()).add("displayName", (Object)this.getDisplayName());
    }
}

