/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import org.openqa.selenium.By;

public class UserAccountNotificationSettingsPage
extends BitbucketPage {
    private static final String NOTIFICATION_SEND_MODE_ID = "notification-send-mode";
    @ElementBy(className="notification-settings-form")
    private PageElement settingsForm;

    public String getUrl() {
        return "/plugins/servlet/notification/settings";
    }

    public String getSelectedSendMode(String sendMode) {
        AuiCheckbox selectedMode = ElementUtils.findCheckbox((PageElementFinder)this.settingsForm, By.cssSelector((String)("#" + sendMode + "-notification-send-mode input:checked")));
        return selectedMode.getAttribute("value");
    }

    public void save() {
        this.settingsForm.find(By.className((String)"save")).click();
    }

    public UserAccountNotificationSettingsPage setSelectedSendMode(String newMode, String sendMode) {
        AuiCheckbox mode = ElementUtils.findCheckbox((PageElementFinder)this.settingsForm, By.id((String)(sendMode + "-setting-" + newMode.toLowerCase())));
        if (mode == null) {
            throw new IllegalArgumentException("Option for mode " + newMode + " does not exist!");
        }
        mode.select();
        return this;
    }
}

