/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import jakarta.ws.rs.core.Response;
import org.openqa.selenium.By;

public class ErrorPage
extends BitbucketPage {
    private static final String ERROR_DIV_SELECTOR = "div.error-image";
    @ElementBy(cssSelector="div.error-image")
    PageElement errorDiv;
    private final String url;

    public ErrorPage(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public Response.Status getError() {
        String divClass = this.errorDiv.getAttribute("class");
        for (Response.Status status : Response.Status.values()) {
            if (!divClass.contains(Integer.toString(status.getStatusCode()))) continue;
            return status;
        }
        throw new AssertionError((Object)"Unable to find error status code on page.");
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)ERROR_DIV_SELECTOR)).timed().isVisible());
    }
}

