/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.PageBindingWaitException;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.EventUtils;
import com.atlassian.webdriver.bitbucket.util.ScrollInfo;
import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public abstract class AbstractPage
implements Page {
    @Inject
    protected WebDriver driver;
    @Inject
    protected JavascriptExecutor javascriptExecutor;
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected PageElementFinder elementFinder;
    @Inject
    protected Timeouts timeouts;
    @ElementBy(tagName="html")
    protected PageElement html;
    @ElementBy(tagName="body")
    protected PageElement body;

    public static boolean isOnPage(WebDriver driver, Page page) {
        String actualUrl = driver.getCurrentUrl();
        String expectedUrl = page.getUrl();
        return AbstractPage.getUrlWithoutVariables(actualUrl).endsWith(AbstractPage.getUrlWithoutVariables(expectedUrl));
    }

    protected static String getUrlWithoutVariables(String url) {
        return url.substring(0, url.contains("?") ? url.indexOf(63) : (url.contains("#") ? url.indexOf("#") : url.length()));
    }

    @WaitUntil
    public void doWait() {
        try {
            Poller.waitUntilTrue((TimedQuery)this.isHereTimed());
        }
        catch (AssertionError e) {
            throw new PageBindingWaitException(String.format("Page failed to load at expected URL.\n\t\tExpected: %s\n\t\tActual:   %s", this.getUrl(), StringUtils.removeStart((String)this.driver.getCurrentUrl(), (String)DefaultFuncTestData.getBaseURL())), (Object)this, (Throwable)((Object)e));
        }
        Poller.waitUntilTrue((String)"Expected html tag to be present", (TimedQuery)this.elementFinder.find(By.tagName((String)"html")).timed().isPresent());
    }

    public boolean isHere() {
        return AbstractPage.isOnPage(this.driver, this);
    }

    public TimedCondition isHereTimed() {
        return Conditions.forSupplier((Timeouts)this.timeouts, this::isHere, (TimeoutType)TimeoutType.PAGE_LOAD);
    }

    public void refresh() {
        this.driver.navigate().refresh();
    }

    public void scrollToTop() {
        ElementUtils.scrollDocument(this.body, 0);
    }

    public void scrollToBottom() {
        ElementUtils.scrollDocument(this.body);
    }

    public void scrollBody(int scrollTop) {
        ElementUtils.scrollDocument(this.body, scrollTop);
    }

    public int getBodyHeight() {
        return ElementUtils.getScrollInfo(this.body).getScrollHeight();
    }

    public ScrollInfo getScrollInfo() {
        return ElementUtils.getScrollInfo(this.html);
    }

    public void waitForPageLoad(Runnable runnable) {
        this.waitForPageLoad(() -> {
            runnable.run();
            return null;
        });
    }

    public <T> T waitForPageLoad(Supplier<T> supplier, Poller.WaitTimeout waitTimeout) {
        this.javascriptExecutor.executeScript("window.pagePopExpected = true;", new Object[0]);
        Object t = supplier.get();
        Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, () -> (Boolean)this.javascriptExecutor.executeScript("return window && window.pagePopExpected !== true;", new Object[0])), (Matcher)Matchers.is((Object)true), (Poller.WaitTimeout)waitTimeout);
        return (T)t;
    }

    public <T> T waitForPageLoad(Supplier<T> supplier) {
        return this.waitForPageLoad(supplier, Poller.byDefaultTimeout());
    }

    public void waitUntilEventFired(String eventName, Runnable runnable) {
        EventUtils.waitUntilEventFired(eventName, runnable, this.javascriptExecutor, this.timeouts);
    }
}

