/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.hooks;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.hooks.RepositoryHookSettingsDialog;
import com.atlassian.webdriver.bitbucket.page.admin.hooks.RepositoryHooksPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.Objects;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.openqa.selenium.By;

public abstract class RepositoryHookRow
extends AbstractElementPageObject {
    @Inject
    protected PageElementActions actions;
    @ElementBy(className="busy-value")
    protected PageElement loadingIndicator;
    protected final RepositoryHooksPage<?> parent;

    RepositoryHookRow(@Nonnull PageElement row, @Nonnull RepositoryHooksPage<?> parent) {
        super(row);
        this.parent = Objects.requireNonNull(parent, "parent");
    }

    public RepositoryHookRow bind() {
        return (RepositoryHookRow)this.pageBinder.bind(RepositoryHookRow.class, new Object[]{this.container, this.parent});
    }

    public RepositoryHookRow edit(@Nonnull Consumer<RepositoryHookSettingsDialog> callback) {
        PageElement actionsCell = this.find(By.cssSelector((String)".hook-toggle-cell .aui-button"));
        ElementUtils.scrollIntoView(actionsCell);
        actionsCell.click();
        PageElement editButton = this.container.find(By.cssSelector((String)"[data-testid='edit-hook']"));
        Poller.waitUntilTrue((TimedQuery)editButton.timed().isVisible());
        editButton.click();
        RepositoryHookSettingsDialog dialog = (RepositoryHookSettingsDialog)((Object)this.pageBinder.bind(RepositoryHookSettingsDialog.class, new Object[]{By.id((String)"hook-config-dialog"), this}));
        Poller.waitUntil((TimedQuery)dialog.isOpen(), (Matcher)IsEqual.equalTo((Object)true));
        callback.accept(dialog);
        Poller.waitUntil((TimedQuery)dialog.isOpen(), (Matcher)IsEqual.equalTo((Object)false));
        return this.bind();
    }

    public String getDescription() {
        return this.find(By.className((String)"hook-description")).getText();
    }

    public String getName() {
        PageElement element = this.find(By.className((String)"hook-summary-cell")).find(By.tagName((String)"h4"));
        if (element.isPresent()) {
            return element.getText();
        }
        return this.find(By.cssSelector((String)".hook-summary-cell .aui-button")).getText();
    }

    public abstract TimedQuery<RepositoryChangesState> getRepositoryChangesState();

    public abstract TimedQuery<HookState> getState();

    public RepositoryHookRow setState(HookState hookState) {
        RepositoryHookRow hook = this.setState(hookState, null);
        Poller.waitUntil(hook.getState(), (Matcher)IsEqual.equalTo((Object)((Object)hookState)));
        return hook;
    }

    public RepositoryHookRow setState(HookState hookState, @Nullable Consumer<RepositoryHookSettingsDialog> callback) {
        this.selectState(hookState);
        if (callback != null) {
            RepositoryHookSettingsDialog dialog = (RepositoryHookSettingsDialog)((Object)this.pageBinder.bind(RepositoryHookSettingsDialog.class, new Object[]{By.id((String)"hook-config-dialog"), this}));
            Poller.waitUntil((TimedQuery)dialog.isOpen(), (Matcher)IsEqual.equalTo((Object)true));
            callback.accept(dialog);
            Poller.waitUntil((TimedQuery)dialog.isOpen(), (Matcher)IsEqual.equalTo((Object)false));
        }
        return this.bind();
    }

    public TimedQuery<Boolean> verifyElementHasAttribute(String className, String attributeName, String attributeValue) {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            ElementUtils.scrollIntoView(this.container.find(By.cssSelector((String)className)));
            return this.container.find(By.cssSelector((String)className)).hasAttribute(attributeName, attributeValue);
        });
    }

    protected PageElement getHookCustomizableCell() {
        return this.container.find(By.cssSelector((String)".hook-customizable-cell"));
    }

    protected PageElement getHookStatusCell() {
        return this.container.find(By.cssSelector((String)".hook-status-cell"));
    }

    protected void selectState(HookState hookState) {
        ElementUtils.scrollIntoView(this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")));
        this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")).click();
        switch (hookState.ordinal()) {
            case 2: 
            case 3: {
                this.container.find(By.cssSelector((String)"[data-testid='inherit']")).click();
                break;
            }
            case 0: {
                this.container.find(By.cssSelector((String)"[data-testid='enable']")).click();
                break;
            }
            case 1: {
                this.container.find(By.cssSelector((String)"[data-testid='disable']")).click();
            }
        }
    }

    public static enum HookState {
        ENABLED,
        DISABLED,
        INHERITED_ENABLED,
        INHERITED_DISABLED;


        public static HookState getHookState(boolean disabled) {
            return disabled ? DISABLED : ENABLED;
        }

        public static HookState getHookState(boolean disabled, boolean inherited) {
            if (inherited) {
                return disabled ? INHERITED_DISABLED : INHERITED_ENABLED;
            }
            return disabled ? DISABLED : ENABLED;
        }
    }

    public static enum RepositoryChangesState {
        ALLOWED,
        NOT_ALLOWED;


        public static RepositoryChangesState isAllowed(boolean isAllowed) {
            return isAllowed ? ALLOWED : NOT_ALLOWED;
        }
    }
}

