/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriverException;

public abstract class Select2<S extends Select2<S, O>, O extends Option>
extends AbstractElementPageObject {
    protected static final String NO_RESULTS_CLASS = "select2-no-results";
    protected static final String RESULT_WITH_CHILDREN = "select2-result-with-children";
    protected static final String UNSELECTABLE_RESULT = "select2-result-unselectable";
    protected static final String SEARCH_FIELD_CLASS = "select2-search-field";
    protected static final String INPUT_FIELD_CLASS = "select2-input";
    protected final Class<O> optionClass;
    @Inject
    protected PageElementActions actions;
    @Inject
    protected PageElementFinder elementFinder;
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected Timeouts timeouts;
    @ElementBy(id="select2-drop", timeoutType=TimeoutType.AJAX_ACTION)
    private PageElement dropdown;

    protected Select2(@Nonnull PageElement container, @Nonnull Class<O> optionClass) {
        super(container);
        this.optionClass = Objects.requireNonNull(optionClass, "optionClass");
    }

    @Nonnull
    public S clearFilter() {
        this.getInput().clear();
        Poller.waitUntilFalse((TimedQuery)this.isInputActive());
        this.type(new CharSequence[]{Keys.BACK_SPACE});
        return this.self();
    }

    @Nonnull
    public TimedQuery<Integer> getOptionCount() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> Iterables.size((Iterable)((Iterable)this.getOptions().now())));
    }

    @Nonnull
    public TimedQuery<List<O>> getOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            if (!((Boolean)this.isOptionsOpen().now()).booleanValue()) {
                return Collections.emptyList();
            }
            return this.getOptionsContainer().findAll(Locators.listItem()).stream().filter(elementFinder -> !elementFinder.hasClass(NO_RESULTS_CLASS)).filter(elementFinder -> !elementFinder.hasClass(RESULT_WITH_CHILDREN) || !elementFinder.hasClass(UNSELECTABLE_RESULT)).map(elementFinder -> (Option)this.pageBinder.bind(this.optionClass, new Object[]{elementFinder})).collect(Collectors.toList());
        });
    }

    @Nonnull
    public TimedQuery<Integer> getSelectedOptionCount() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> Iterables.size((Iterable)((Iterable)this.getSelectedOptions().now())));
    }

    @Nonnull
    public TimedQuery<Iterable<O>> getSelectedOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            if (((Boolean)this.isDropDown().now()).booleanValue()) {
                return Chainable.chain((Iterable)this.getSelectedOptionContainer().findAll(By.className((String)"select2-chosen"))).transform(ElementUtils.bind(this.pageBinder, this.optionClass, new Object[0])).toList();
            }
            return Chainable.chain((Iterable)this.getSelectedOptionsContainer().findAll(Locators.listItem())).filter(element -> !element.hasClass(SEARCH_FIELD_CLASS)).transform(ElementUtils.bind(this.pageBinder, this.optionClass, new Object[0])).toList();
        });
    }

    @Nonnull
    public TimedCondition hasNoOptions() {
        return this.getOptionsContainer().find(By.className((String)NO_RESULTS_CLASS)).timed().isPresent();
    }

    public S clearValue() {
        if (((Boolean)this.isAllowClear().now()).booleanValue() && ((Boolean)this.hasValue().now()).booleanValue()) {
            this.container.find(By.className((String)"select2-arrow")).click();
        }
        return this.self();
    }

    @Nonnull
    public TimedCondition hasValue() {
        return Conditions.forSupplier((Timeouts)this.timeouts, () -> !this.container.findAll(By.className((String)"select2-search-choice-close")).isEmpty());
    }

    @Nonnull
    public TimedCondition isMultiSelect() {
        return this.container.timed().hasClass("select2-container-multi");
    }

    @Nonnull
    public TimedCondition isDropDown() {
        return this.getSelectedOptionContainer().timed().isPresent();
    }

    @Nonnull
    public TimedCondition isOptionsOpen() {
        return this.dropdown.timed().isVisible();
    }

    @Nonnull
    public TimedCondition isAllowClear() {
        return this.container.timed().hasClass("select2-allowclear");
    }

    @Nonnull
    public S openOptions() {
        if (((Boolean)this.isOptionsOpen().now()).booleanValue()) {
            return this.self();
        }
        this.clearValue();
        if (((Boolean)this.isMultiSelect().now()).booleanValue()) {
            this.type(new CharSequence[]{Keys.ARROW_DOWN});
        } else if (((Boolean)this.isDropDown().now()).booleanValue()) {
            this.getSelectedOptionContainer().click();
        } else {
            this.container.find(By.className((String)"select2-default")).click();
        }
        Poller.waitUntilTrue((TimedQuery)this.isOptionsOpen());
        return this.self();
    }

    @Nonnull
    public S closeOptions() {
        if (((Boolean)this.isOptionsOpen().now()).booleanValue()) {
            this.actions.sendKeys(new CharSequence[]{Keys.ESCAPE}).perform();
        }
        Poller.waitUntilFalse((TimedQuery)this.isOptionsOpen());
        return this.self();
    }

    @Nonnull
    public S removeOption(@Nonnull O option) {
        Objects.requireNonNull(option, "option");
        String optionInfo = ((Option)option).toString();
        Poller.waitUntilTrue((String)String.format("Unable to remove option '%s', remove link not visible", optionInfo), (TimedQuery)((Option)option).getRemoveLink().timed().isVisible());
        int selectedCount = (Integer)this.getSelectedOptionCount().now();
        ((Option)option).getRemoveLink().click();
        Poller.waitUntilEquals((String)("Selected option count expected to decrease by 1 after removing option " + optionInfo), (Object)(selectedCount - 1), this.getSelectedOptionCount());
        return this.self();
    }

    @Nonnull
    public S removeAll() {
        Option selected = (Option)Iterables.getFirst((Iterable)((Iterable)this.getSelectedOptions().now()), null);
        while (selected != null) {
            this.removeOption(selected);
            selected = (Option)Iterables.getFirst((Iterable)((Iterable)this.getSelectedOptions().now()), null);
        }
        return this.self();
    }

    @Nonnull
    public S selectOption(@Nonnull O option) {
        Objects.requireNonNull(option, "option");
        Poller.waitUntilTrue((TimedQuery)((Option)option).container.timed().isVisible());
        ((Option)option).container.click();
        Poller.waitUntilFalse((TimedQuery)this.isOptionsOpen());
        return this.self();
    }

    @Nonnull
    public S selectFirst() {
        Poller.waitUntilEquals((String)("Expected only one option available, but was: " + String.valueOf(this.getOptions().now())), (Object)1, this.getOptionCount());
        return this.selectOption(MoreStreams.streamIterable((Iterable)((Iterable)this.getOptions().now())).findFirst().orElse(null));
    }

    @Nonnull
    public S type(CharSequence ... filter) {
        this.getInput().type(filter);
        Poller.waitUntilFalse((TimedQuery)this.isInputActive());
        return this.self();
    }

    @Nullable
    protected O findOption(@Nonnull Predicate<O> optionPredicate) {
        if (!((Boolean)this.isOptionsOpen().now()).booleanValue()) {
            return null;
        }
        return (O)((Option)MoreStreams.streamIterable((Iterable)((Iterable)this.getOptions().now())).filter(arg_0 -> optionPredicate.apply(arg_0)).findFirst().orElse(null));
    }

    @Nullable
    protected O findSelectedOption(@Nonnull Predicate<O> optionPredicate) {
        return (O)((Option)MoreStreams.streamIterable((Iterable)((Iterable)this.getSelectedOptions().now())).filter(arg_0 -> optionPredicate.apply(arg_0)).findFirst().orElse(null));
    }

    @Nonnull
    protected PageElement getSelectedOptionContainer() {
        return this.find(By.className((String)"select2-choice"));
    }

    @Nonnull
    protected PageElement getSelectedOptionsContainer() {
        return this.find(By.className((String)"select2-choices"));
    }

    @Nonnull
    protected PageElement getOptionsContainer() {
        return this.dropdown.find(By.className((String)"select2-results"));
    }

    @Nonnull
    protected PageElement getInput() {
        if (((Boolean)this.isMultiSelect().now()).booleanValue()) {
            return this.find(By.className((String)INPUT_FIELD_CLASS));
        }
        return this.dropdown.find(By.className((String)INPUT_FIELD_CLASS));
    }

    @Nonnull
    protected TimedCondition hasOption(@Nonnull Predicate<O> optionPredicate) {
        return Conditions.forSupplier((Timeouts)this.timeouts, () -> this.findOption(optionPredicate) != null);
    }

    @Nonnull
    protected TimedCondition hasSelectedOption(@Nonnull Predicate<O> optionPredicate) {
        return Conditions.forSupplier((Timeouts)this.timeouts, () -> this.findSelectedOption(optionPredicate) != null);
    }

    @Nonnull
    protected TimedCondition isInputActive() {
        return this.getInput().timed().hasClass("select2-active");
    }

    @Nonnull
    protected S self() {
        return (S)this;
    }

    private int countSelected() {
        return this.container.findAll(By.className((String)"select2-search-choice")).size();
    }

    private List<PageElement> getChoices() {
        return this.container.findAll(By.cssSelector((String)".select2-choices .select2-search-choice"));
    }

    public Select2 remove(Predicate<PageElement> predicate) {
        Lists.reverse(this.getChoices()).stream().filter(arg_0 -> predicate.apply(arg_0)).forEach(e -> {
            int count = this.countSelected() - 1;
            e.find(By.className((String)"select2-search-choice-close")).click();
            Poller.waitUntilEquals((Object)count, (TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, this::countSelected));
        });
        return this;
    }

    public <T> List<T> getValues(Function<PageElement, T> f) {
        return this.getChoices().stream().map(f).collect(Collectors.toList());
    }

    public static class Option {
        protected final PageElement container;

        public Option(@Nonnull PageElement container) {
            this.container = Objects.requireNonNull(container, "container");
        }

        @Nonnull
        public <T extends Option> T as(Class<T> targetType) {
            return (T)((Option)Objects.requireNonNull(targetType, "targetType").cast(this));
        }

        @Nullable
        public String getText() {
            return this.container.getText();
        }

        public final String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            try {
                toStringHelper.add("text", (Object)this.getText());
                this.extendToString(toStringHelper);
            }
            catch (WebDriverException e) {
                toStringHelper.add("exception", (Object)e.getMessage());
            }
            return toStringHelper.toString();
        }

        protected void extendToString(MoreObjects.ToStringHelper toStringHelper) {
        }

        @Nonnull
        protected PageElement getRemoveLink() {
            return this.container.find(By.className((String)"select2-search-choice-close"));
        }
    }
}

