/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.page.RepositoryAccessKeySettingsPage;
import com.atlassian.bitbucket.pageobjects.page.ScopedAccessKeyFormPage;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;

public class RepositoryAccessKeyFormPage
extends ScopedAccessKeyFormPage {
    private final int accessKeyId;
    private final String projectKey;
    private final String slug;

    public RepositoryAccessKeyFormPage(String projectKey, String slug) {
        this.projectKey = projectKey;
        this.slug = slug;
        this.accessKeyId = -1;
    }

    public RepositoryAccessKeyFormPage(String projectKey, String slug, int accessKeyId) {
        this.projectKey = projectKey;
        this.slug = slug;
        this.accessKeyId = accessKeyId;
    }

    public RepositoryAccessKeySettingsPage clickCancel() {
        Poller.waitUntilTrue((TimedQuery)this.cancelButton.timed().isVisible());
        this.cancelButton.click();
        return (RepositoryAccessKeySettingsPage)this.pageBinder.bind(RepositoryAccessKeySettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryAccessKeySettingsPage clickSave() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isVisible());
        this.saveButton.click();
        return (RepositoryAccessKeySettingsPage)this.pageBinder.bind(RepositoryAccessKeySettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryAccessKeyFormPage clickSaveGoBackToFormPage() {
        Poller.waitUntilTrue((TimedQuery)this.saveButton.timed().isVisible());
        this.saveButton.click();
        return (RepositoryAccessKeyFormPage)this.pageBinder.bind(RepositoryAccessKeyFormPage.class, new Object[]{this.projectKey, this.slug});
    }

    public String getUrl() {
        if (this.accessKeyId == -1) {
            return String.format("/plugins/servlet/ssh/projects/%s/repos/%s/keys/add", this.projectKey, this.slug);
        }
        return String.format("/plugins/servlet/ssh/projects/%s/repos/%s/keys/edit/%s", this.projectKey, this.slug, this.accessKeyId);
    }

    public RepositoryAccessKeyFormPage setKeyLabel(String value) {
        Poller.waitUntilTrue((TimedQuery)this.sshKeyLabel.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.sshKeyLabel.timed().isEnabled());
        this.sshKeyLabel.clear().type(new CharSequence[]{value});
        return this;
    }

    public RepositoryAccessKeyFormPage setKeyText(String value) {
        Poller.waitUntilTrue((TimedQuery)this.sshKeyText.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.sshKeyText.timed().isEnabled());
        this.sshKeyText.clear().type(new CharSequence[]{value});
        return this;
    }
}

