/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.element.PullRequestAvatar;
import com.atlassian.bitbucket.pageobjects.element.PullRequestEditDialog;
import com.atlassian.bitbucket.pageobjects.element.PullRequestHeader;
import com.atlassian.bitbucket.pageobjects.element.PullRequestMergeConfirmDialog;
import com.atlassian.bitbucket.pageobjects.element.PullRequestTabs;
import com.atlassian.bitbucket.pageobjects.element.tasks.PullRequestTaskListDialog;
import com.atlassian.bitbucket.pageobjects.page.PullRequestCommitPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestDiffPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestEffectiveDiffPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestIterativeDiffPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestOverviewPage;
import com.atlassian.bitbucket.pageobjects.page.PullRequestTabCSEPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.util.KeyboardShortcuts;
import com.atlassian.webdriver.bitbucket.util.Locators;
import com.atlassian.webdriver.bitbucket.util.TimedUtils;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public abstract class PullRequestPage<T extends PullRequestPage<T>>
extends BaseRepositoryPage {
    private final long pullRequestId;
    @ElementBy(className="pull-request-header")
    private PageElement pullRequestHeader;
    @ElementBy(className="tabs-menu")
    private PageElement pullRequestTabs;

    public PullRequestPage(String projectKey, String slug, long pullRequestId) {
        super(projectKey, slug);
        this.pullRequestId = pullRequestId;
    }

    public PullRequestPage<T> addSelfAsReviewer() {
        this.getPullRequestHeader().addSelfAsReviewer();
        return this;
    }

    public PullRequestPage<T> approve() {
        this.getPullRequestHeader().getApproveButton().withTimeout(TimeoutType.UI_ACTION).click();
        return this;
    }

    public PullRequestPage<T> cancelDelete() {
        this.getPullRequestHeader().clickDelete().clickButton("Cancel");
        return this;
    }

    public PullRequestPage<T> decline() {
        this.getPullRequestHeader().clickDecline().clickButton("Decline");
        return this;
    }

    public PullRequestPage<T> delete() {
        this.getPullRequestHeader().clickDelete().clickButton("Delete pull request");
        return this;
    }

    public PullRequestPage<T> download(String button) {
        PageElement downloadOptions = this.getPullRequestHeader().clickDownload();
        downloadOptions.find(By.cssSelector((String)("[data-testid=" + button + "]"))).click();
        return this;
    }

    public PullRequestEditDialog edit() {
        this.getPullRequestHeader().getEditButton().click();
        return (PullRequestEditDialog)this.pageBinder.bind(PullRequestEditDialog.class, new Object[]{this.elementFinder});
    }

    public PullRequestHeader getPullRequestHeader() {
        this.scrollToTop();
        return (PullRequestHeader)this.pageBinder.bind(PullRequestHeader.class, new Object[]{this.pullRequestHeader});
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public PullRequestTabs getPullRequestTabs() {
        this.scrollToTop();
        return (PullRequestTabs)this.pageBinder.bind(PullRequestTabs.class, new Object[]{this.pullRequestTabs});
    }

    public TimedQuery<List<PullRequestAvatar>> getReviewers() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.getPullRequestHeader().getReviewers());
    }

    public PageElement getTasksOverviewButton() {
        PageElement button = this.getPullRequestHeader().getTasksOverviewButton();
        return (Boolean)button.timed().isPresent().byDefaultTimeout() != false ? button : null;
    }

    public TimedQuery<Integer> getUnresolvedTaskCount() {
        return TimedUtils.toMappable(this.getPullRequestHeader().getTasksOverviewCount().timed().getText()).map(Integer::parseInt);
    }

    public String getUrl() {
        if (this.projectKey.startsWith("~")) {
            return "/users/" + this.projectKey.substring(1).toLowerCase() + "/repos/" + this.slug + "/pull-requests/" + this.pullRequestId;
        }
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/pull-requests/" + this.pullRequestId;
    }

    public PullRequestPage<T> markAsDraft() {
        this.getPullRequestHeader().clickMarkAsDraft();
        Poller.waitUntilTrue((TimedQuery)this.getPullRequestHeader().getPublishButton().timed().isVisible());
        return this;
    }

    public PullRequestPage<T> merge() {
        this.openMergeConfirmDialog().confirmMerge();
        this.waitUntilState(State.MERGED);
        return this;
    }

    public PullRequestCommitPage navigateToCommitsPage() {
        PullRequestTabs pullRequestTabs = this.getPullRequestTabs();
        pullRequestTabs.getCommitsTab().click();
        return (PullRequestCommitPage)this.pageBinder.bind(PullRequestCommitPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId});
    }

    public PullRequestEffectiveDiffPage navigateToEffectiveDiff() {
        return this.navigateToDiffPage(PullRequestEffectiveDiffPage.class, this.projectKey, this.slug, this.pullRequestId);
    }

    public PullRequestIterativeDiffPage navigateToIterativeDiff(String sinceCommitId, String untilCommitId) {
        return this.navigateToDiffPage(PullRequestIterativeDiffPage.class, this.projectKey, this.slug, this.pullRequestId, sinceCommitId, untilCommitId);
    }

    public PullRequestOverviewPage navigateToOverviewPage() {
        PullRequestTabs pullRequestTabs = this.getPullRequestTabs();
        pullRequestTabs.getOverviewTab().click();
        return (PullRequestOverviewPage)this.pageBinder.bind(PullRequestOverviewPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId});
    }

    public PullRequestTabCSEPage navigateToTabExtension(String urlSlug) {
        PullRequestTabs pullRequestTabs = this.getPullRequestTabs();
        pullRequestTabs.getCSETab(urlSlug).click();
        return (PullRequestTabCSEPage)this.pageBinder.bind(PullRequestTabCSEPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId, urlSlug});
    }

    public PullRequestPage<T> needsWork() {
        this.getPullRequestHeader().getNeedsWorkButton().withTimeout(TimeoutType.UI_ACTION).click();
        return this;
    }

    public PullRequestMergeConfirmDialog openMergeConfirmDialog() {
        this.getPullRequestHeader().getMergeButton().click();
        return this.getPullRequestHeader().getMergeConfirmDialog();
    }

    public PullRequestTaskListDialog openTaskListDialog() {
        this.getTasksOverviewButton().click();
        return (PullRequestTaskListDialog)this.pageBinder.bind(PullRequestTaskListDialog.class, new Object[]{this.elementFinder});
    }

    public PullRequestTaskListDialog openTaskListDialogWithKeyboardShortcut() {
        KeyboardShortcuts.press(this.elementFinder.find(Locators.body()), Keys.chord((CharSequence[])new CharSequence[]{Keys.SHIFT, "t"}));
        return (PullRequestTaskListDialog)this.pageBinder.bind(PullRequestTaskListDialog.class, new Object[]{this.elementFinder});
    }

    public PullRequestPage<T> publishDraft() {
        this.getPullRequestHeader().getPublishButton().withTimeout(TimeoutType.UI_ACTION).click();
        Poller.waitUntilTrue((TimedQuery)this.getPullRequestHeader().getMergeButton().timed().isVisible());
        return this;
    }

    public PullRequestPage<T> removeSelfAsReviewer() {
        this.getPullRequestHeader().getRemoveSelfAsReviewerButton().click();
        PageElement removeSelfDialogButton = this.elementFinder.find(By.cssSelector((String)".remove-self-dialog button"));
        Poller.waitUntilTrue((TimedQuery)removeSelfDialogButton.timed().isVisible());
        removeSelfDialogButton.click();
        return this;
    }

    public PullRequestPage<T> reopen() {
        PageElement reOpenButton = this.getPullRequestHeader().getReOpenButton();
        Poller.waitUntilTrue((TimedQuery)reOpenButton.timed().isVisible());
        reOpenButton.click();
        return this;
    }

    public PullRequestPage<T> startReviewModeFromButton() {
        PageElement startReviewButton = this.getPullRequestHeader().getStartReviewButton();
        Poller.waitUntilTrue((TimedQuery)startReviewButton.timed().isVisible());
        startReviewButton.click();
        return this;
    }

    public void waitUntilState(State state) {
        Poller.waitUntil((TimedQuery)this.getPullRequestHeader().getState().timed().getText(), (Matcher)Matchers.equalTo((Object)state.toString()));
    }

    private <T extends PullRequestDiffPage> T navigateToDiffPage(Class<T> diffPageClass, Object ... bindArgs) {
        PullRequestTabs pullRequestTabs = this.getPullRequestTabs();
        pullRequestTabs.getDiffTab().click();
        return (T)((PullRequestDiffPage)this.pageBinder.bind(diffPageClass, bindArgs));
    }

    public static enum State {
        OPEN,
        MERGED,
        DECLINED;

    }
}

