/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.next;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import org.openqa.selenium.By;

public class EditFileCommitDialog
extends AbstractElementPageObject {
    public EditFileCommitDialog(@Nonnull PageElement container) {
        super(container);
    }

    public void clickCancelLink() {
        this.getCancelLink().click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isPresent());
    }

    public PageElement getBranchNameTextbox() {
        return this.find(By.cssSelector((String)"[data-testid='commit-dialog-branchname-input']"));
    }

    public PageElement getCommitLink() {
        return this.find(By.cssSelector((String)"[data-testid='commit-dialog-commit']"));
    }

    public PageElement getCommitTextbox() {
        return this.find(By.cssSelector((String)"[data-testid='commit-dialog-title-input']"));
    }

    public PageElement getCreatePrCheckbox() {
        return this.find(By.cssSelector((String)"[data-testid='commit-dialog-pr-checkbox'] input"));
    }

    public TimedCondition isOpen() {
        return this.container.timed().isPresent();
    }

    public void setCommitMessage(String commitMessage) {
        this.getCommitTextbox().javascript().execute("arguments[0].CodeMirror.setValue('" + commitMessage.replace("\n", "\\n").replace("\t", "\\t").replace("'", "\\'") + "');", new Object[0]);
    }

    public void setCommitMessageTitle(String commitMessage) {
        this.getCommitTextbox().type(new CharSequence[]{commitMessage});
    }

    public void toggleCreatePrCheckbox(boolean checked) {
        PageElement checkbox = this.getCreatePrCheckbox();
        if (checkbox.isSelected() != checked) {
            checkbox.click();
        }
    }

    private PageElement getCancelLink() {
        return this.find(By.cssSelector((String)"[data-testid='commit-dialog-cancel']"));
    }
}

