/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.codeinsights;

import com.atlassian.bitbucket.pageobjects.element.codeinsights.CodeInsightsOverviewReport;
import com.atlassian.bitbucket.pageobjects.element.codeinsights.CodeInsightsOverviewReportMenuItem;
import com.atlassian.bitbucket.pageobjects.page.PullRequestPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import org.openqa.selenium.By;

public class CodeInsightsOverviewDialog
extends AbstractElementPageObject {
    private final PullRequestPage parent;
    @ElementBy(className="reports-list")
    private PageElement reportList;

    public CodeInsightsOverviewDialog(PageElement container, PullRequestPage parent) {
        super(container);
        this.parent = parent;
    }

    public String getProjectKey() {
        return this.parent.getProjectKey();
    }

    public long getPullRequestId() {
        return this.parent.getPullRequestId();
    }

    public int getReportCount() {
        Poller.waitUntilTrue((TimedQuery)this.reportList.timed().isVisible());
        return this.reportList.findAll(By.className((String)"code-insights-report-button")).size() - 1;
    }

    public CodeInsightsOverviewReportMenuItem getSelectedMenuItem() {
        return (CodeInsightsOverviewReportMenuItem)this.pageBinder.bind(CodeInsightsOverviewReportMenuItem.class, new Object[]{this.find(By.cssSelector((String)".code-insights-report-button.selected"))});
    }

    public CodeInsightsOverviewReport getSelectedReport() {
        return (CodeInsightsOverviewReport)this.pageBinder.bind(CodeInsightsOverviewReport.class, new Object[]{this.find(By.className((String)"code-insights-report-details")), this});
    }

    public String getSlug() {
        return this.parent.getSlug();
    }

    public CodeInsightsOverviewReportMenuItem selectReport(int index) {
        PageElement el = (PageElement)this.container.findAll(By.cssSelector((String)".reports-list li")).get(index);
        el.click();
        return (CodeInsightsOverviewReportMenuItem)this.pageBinder.bind(CodeInsightsOverviewReportMenuItem.class, new Object[]{el});
    }
}

