/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class ProjectSettingsRestrictionSelector
extends AbstractElementPageObject {
    @Inject
    private PageElementFinder elementFinder;

    public ProjectSettingsRestrictionSelector(@Nonnull PageElement container) {
        super(container);
    }

    public ProjectSettingsRestrictionSelector createRestriction() {
        this.openDropdown();
        Poller.waitUntil(this.getDropdownOptions(), (Matcher)Matchers.iterableWithSize((int)2));
        List dropDownOptions = (List)this.getDropdownOptions().now();
        ((PageElement)dropDownOptions.get(0)).click();
        return this;
    }

    public ProjectSettingsRestrictionSelector deleteRestriction() {
        this.openDropdown();
        Poller.waitUntil(this.getDropdownOptions(), (Matcher)Matchers.iterableWithSize((int)2));
        List dropDownOptions = (List)this.getDropdownOptions().now();
        ((PageElement)dropDownOptions.get(1)).click();
        return this;
    }

    public boolean isRestricted() {
        return this.container.find(By.cssSelector((String)"span .locked-icon")).isPresent();
    }

    public void waitUntilDisabled() {
        Poller.waitUntilFalse((TimedQuery)this.isMenuTriggerEnabled());
    }

    public void waitUntilEnabled() {
        Poller.waitUntilTrue((TimedQuery)this.isMenuTriggerEnabled());
    }

    private TimedQuery<List<PageElement>> getDropdownOptions() {
        List menuItems = this.elementFinder.findAll(By.cssSelector((String)"button[role=\"menuitem\"]"));
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)menuItems.stream().collect(MoreCollectors.toImmutableList()));
    }

    private TimedCondition isMenuTriggerEnabled() {
        PageElement menuTrigger = this.find(By.cssSelector((String)"[data-testid='restriction-menu-trigger']"));
        Poller.waitUntilTrue((TimedQuery)menuTrigger.timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)menuTrigger.timed().isPresent());
        return menuTrigger.timed().isEnabled();
    }

    private void openDropdown() {
        this.container.find(By.cssSelector((String)"[data-testid='restriction-menu-trigger']")).click();
    }
}

