/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import org.openqa.selenium.By;

public class FileTreeNode
extends AbstractElementPageObject {
    public FileTreeNode(@Nonnull PageElement container) {
        super(container);
    }

    public FileTreeNode clickFile() {
        this.find(By.className((String)"file-label")).withTimeout(TimeoutType.UI_ACTION).click();
        return this;
    }

    public String getDirectoryName() {
        return this.find(By.cssSelector((String)".directory-label:first-child")).getText();
    }

    public String getFileName() {
        return this.find(By.className((String)"file-label")).getText();
    }

    public String getPath() {
        return this.find(By.tagName((String)"a")).getAttribute("href").replaceAll(".*#", "");
    }

    public boolean isCommented() {
        return this.isLeaf() && this.find(By.className((String)"file-comment-indicator")).isPresent();
    }

    public boolean isConflicted() {
        return this.isLeaf() && this.container.hasClass("file-with-conflict");
    }

    public boolean isLeaf() {
        return this.container.hasClass("file");
    }

    public boolean isSelected() {
        return this.isLeaf() && this.container.hasClass("file-selected");
    }

    public boolean isViewed() {
        return this.isLeaf() && this.container.hasClass("file-viewed");
    }
}

