/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.pageobjects.element.FileContentLine;
import com.atlassian.bitbucket.pageobjects.element.comments.Comment;
import com.atlassian.bitbucket.pageobjects.element.comments.CommentForm;
import com.atlassian.bitbucket.pageobjects.element.comments.DiffLineCommentForm;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.openqa.selenium.By;

public class DiffFileContentLine
extends FileContentLine {
    @Inject
    protected PageElementActions actions;

    public DiffFileContentLine(@NotNull PageElement container) {
        super(container);
    }

    public Comment addComment(String message) {
        return ((CommentForm)this.openComment().setText(message)).submitComment();
    }

    public List<Comment> getComments() {
        return (List)this.container.findAll(By.className((String)"comment-with-replies")).stream().map(ElementUtils.bind(this.pageBinder, Comment.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    public PageElement getCommentTrigger() {
        return this.find(By.className((String)"diff-line-comment-trigger"));
    }

    public Comment getLastComment() {
        return (Comment)this.pageBinder.bind(Comment.class, new Object[]{this.getLastCommentElement()});
    }

    public int getLineNumber() {
        if (this.getType() == DiffLineType.ADDED) {
            return Integer.parseInt(this.container.getAttribute("data-line-destination"));
        }
        return Integer.parseInt(this.container.getAttribute("data-line-source"));
    }

    public int getLineNumber(boolean fromToSide) {
        if (fromToSide || this.getType() == DiffLineType.ADDED) {
            return Integer.parseInt(this.container.getAttribute("data-line-destination"));
        }
        return Integer.parseInt(this.container.getAttribute("data-line-source"));
    }

    public DiffFileType getLineSide() {
        return DiffFileType.valueOf((String)this.container.getAttribute("data-line-side"));
    }

    public CommentForm getOpenCommentEditor() {
        return (CommentForm)this.pageBinder.bind(DiffLineCommentForm.class, new Object[]{this.getLastCommentElement(), this});
    }

    public DiffLineType getType() {
        if (this.container.hasClass("added-line")) {
            return DiffLineType.ADDED;
        }
        if (this.container.hasClass("removed-line")) {
            return DiffLineType.REMOVED;
        }
        return DiffLineType.CONTEXT;
    }

    public CommentForm openComment() {
        PageElement trigger = this.find(By.className((String)"diff-line-comment-trigger"));
        trigger.javascript().execute("arguments[0].focus()", new Object[0]);
        Poller.waitUntilTrue((TimedQuery)trigger.timed().isVisible());
        trigger.click();
        return (CommentForm)this.pageBinder.bind(DiffLineCommentForm.class, new Object[]{this.getLastCommentElement(), this});
    }

    private PageElement getLastCommentElement() {
        List commentThreads = this.container.withTimeout(TimeoutType.UI_ACTION).findAll(By.className((String)"comments-thread"));
        return (PageElement)commentThreads.get(commentThreads.size() - 1);
    }

    public static enum DiffLineType {
        ADDED,
        REMOVED,
        CONTEXT;

    }
}

