/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import org.openqa.selenium.By;

public class ConfirmDialog
extends AbstractElementPageObject {
    public ConfirmDialog(@Nonnull PageElement container) {
        super(container);
        Poller.waitUntilTrue((TimedQuery)container.timed().isVisible());
    }

    public void clickButton(String buttonName) {
        this.getButtonByName(buttonName).click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isVisible());
    }

    public String getHeader() {
        return this.find(By.cssSelector((String)"[data-testid='confirm-action-modal--title']")).getText();
    }

    private PageElement getButtonByName(String buttonName) {
        return this.container.findAll(By.tagName((String)"button")).stream().filter(name -> buttonName.equalsIgnoreCase(name.getText())).findFirst().orElse(null);
    }
}

