/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.InternalStashUserVisitor;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.validator.constraints.Email;

@Entity
@Table(name="sta_service_user")
@PrimaryKeyJoinColumn(name="user_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_sta_service_user_id"))
public class InternalServiceUser
extends InternalApplicationUser
implements ServiceUser {
    public static final String TABLE = "sta_service_user";
    public static final int MAX_DISPLAY_NAME_LENGTH = 255;
    public static final int MAX_EMAIL_LENGTH = 255;
    public static final int MAX_LABEL_LENGTH = 128;
    public static final int MAX_NAME_LENGTH = 255;
    public static final ToInternalServiceUserVisitor TO_SERVICE_USER = new ToInternalServiceUserVisitor();
    @Column(name="active", nullable=false)
    private final boolean active;
    @Column(name="display_name", nullable=false)
    @RequiredString(size=255)
    private final String displayName;
    @Column(name="email_address", nullable=false)
    @Email
    @OptionalString(size=255)
    private final String emailAddress;
    @Column(name="label", nullable=false)
    @RequiredString(size=128)
    private final String label;
    @Column(name="slug", nullable=false, unique=true)
    @RequiredString(size=127)
    private final String slug;
    @Column(name="name", nullable=false, unique=true)
    @RequiredString(size=255)
    private final String username;

    protected InternalServiceUser() {
        this.active = false;
        this.displayName = null;
        this.label = null;
        this.emailAddress = null;
        this.slug = null;
        this.username = null;
    }

    protected InternalServiceUser(@Nonnull Builder builder) {
        super(builder);
        this.active = builder.active;
        this.username = (String)Preconditions.checkNotNull((Object)builder.name, (Object)"username");
        this.displayName = builder.displayName == null ? this.username : builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.label = (String)MoreObjects.firstNonNull((Object)builder.label, (Object)"bot");
        this.slug = builder.slug == null ? InternalServiceUser.slugify(this.username) : builder.slug;
    }

    @Override
    public <T> T accept(@Nonnull InternalStashUserVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public <T> T accept(@Nonnull ApplicationUserVisitor<T> visitor) {
        return (T)visitor.visit((ServiceUser)this);
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public String getName() {
        return this.username;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    @Override
    @Nonnull
    public UserType getType() {
        return UserType.SERVICE;
    }

    public boolean isActive() {
        return this.active;
    }

    public static class ToInternalServiceUserVisitor
    implements InternalStashUserVisitor<InternalServiceUser>,
    Function<InternalApplicationUser, InternalServiceUser> {
        private ToInternalServiceUserVisitor() {
        }

        public InternalServiceUser apply(InternalApplicationUser user) {
            return user.accept(this);
        }

        @Override
        public InternalServiceUser visit(@Nonnull InternalNormalUser user) {
            return null;
        }

        @Override
        public InternalServiceUser visit(@Nonnull InternalServiceUser user) {
            return user;
        }
    }

    public static class Builder
    extends InternalApplicationUser.AbstractBuilder<Builder, InternalServiceUser> {
        private boolean active;
        private String displayName;
        private String emailAddress;
        private String label;

        public Builder() {
            this.active = true;
        }

        public Builder(InternalServiceUser user) {
            super(user);
            this.active = user.active;
            this.displayName = user.displayName;
            this.emailAddress = user.emailAddress;
            this.label = user.label;
        }

        public Builder active(boolean value) {
            this.active = value;
            return this.self();
        }

        @Override
        @Nonnull
        public InternalServiceUser build() {
            return new InternalServiceUser(this);
        }

        public Builder displayName(String value) {
            this.displayName = value;
            return this.self();
        }

        public Builder emailAddress(String value) {
            this.emailAddress = value;
            return this.self();
        }

        public Builder label(String value) {
            this.label = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

