/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import javax.annotation.Nonnull;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;

@DiscriminatorValue(value="3")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_sta_pr_mrg_act_id"))
@Table(name="sta_pr_merge_activity")
public class InternalPullRequestMergeActivity
extends InternalPullRequestActivity
implements PullRequestMergeActivity {
    public static final String TABLE = "sta_pr_merge_activity";
    @Column(name="hash", length=40, updatable=false)
    private final String hash;
    @Transient
    private Commit commit;

    protected InternalPullRequestMergeActivity() {
        this.hash = null;
    }

    private InternalPullRequestMergeActivity(Builder builder) {
        super(builder);
        this.hash = builder.hash;
    }

    @Override
    public void accept(@Nonnull PullRequestActivityVisitor visitor) {
        visitor.visit((PullRequestMergeActivity)this);
    }

    public Commit getCommit() {
        return this.commit;
    }

    @OptionalString(minimumSize=40, size=40)
    public String getHash() {
        return this.hash;
    }

    public void setCommit(Commit value) {
        if (this.commit != null) {
            throw new IllegalStateException("You cannot reset the commit after it's been initialized");
        }
        this.commit = value;
    }

    public static class Builder
    extends InternalPullRequestActivity.AbstractPullRequestActivityBuilder<Builder, InternalPullRequestMergeActivity> {
        private String hash;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            super(pullRequest);
            this.action(PullRequestAction.MERGED);
        }

        public Builder(@Nonnull InternalPullRequestMergeActivity activity) {
            super(activity);
            this.hash = activity.getHash();
        }

        @Override
        @Nonnull
        public InternalPullRequestMergeActivity build() {
            return new InternalPullRequestMergeActivity(this);
        }

        @Nonnull
        public Builder hash(String value) {
            this.hash = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

