/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.validation.ConstraintNature;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.TrustedCreate;
import com.atlassian.bitbucket.validation.groups.TrustedUpdate;
import com.atlassian.bitbucket.validation.groups.Update;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.validation.ProjectKeyUnique;
import com.atlassian.stash.internal.validation.ProjectNameUnique;
import com.atlassian.stash.internal.validation.UnsupportedInApplicationMode;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@DiscriminatorColumn(name="project_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@ProjectKeyUnique(groups={Create.class, TrustedCreate.class, Update.class, TrustedUpdate.class}, payload={ConstraintNature.Conflict.class})
@ProjectNameUnique(groups={Create.class, TrustedCreate.class, Update.class, TrustedUpdate.class}, payload={ConstraintNature.Conflict.class})
@Table(name="project", indexes={@Index(name="idx_project_key", columnList="namespace,project_key"), @Index(name="idx_project_name", columnList="namespace,name"), @Index(name="idx_project_type", columnList="project_type")}, uniqueConstraints={@UniqueConstraint(name="uk_project_name", columnNames={"namespace", "name"}), @UniqueConstraint(name="uk_project_key", columnNames={"namespace", "project_key"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalProject
implements Initializable,
Project {
    private static final String ID_GEN = "projectIdGenerator";
    static final String TABLE = "project";
    @Column(name="description")
    private final String description;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="projectIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="projectIdGenerator", table="id_sequence", pkColumnValue="project", allocationSize=20)
    private final int id;
    @Column(name="project_key")
    private final String key;
    @Column(name="name")
    private final String name;
    @Column(name="namespace", unique=false)
    @Type(type="com.atlassian.stash.internal.hibernate.NullPlaceholderStringType", parameters={@Parameter(name="placeholder", value="#")})
    @UnsupportedInApplicationMode(applicationMode={ApplicationMode.DEFAULT})
    private final String namespace;
    @Column(name="project_type", nullable=false, updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.project.ProjectType")})
    private final ProjectType type;

    protected InternalProject() {
        this.description = null;
        this.id = 0;
        this.key = null;
        this.name = null;
        this.namespace = null;
        this.type = ProjectType.NORMAL;
    }

    protected InternalProject(int id, String namespace, String key, String name, String description, ProjectType type) {
        this.description = description;
        this.id = id;
        this.key = StringUtils.upperCase((String)StringUtils.trimToNull((String)StringUtils.defaultString((String)key, (String)name)), (Locale)Locale.ROOT);
        this.namespace = InternalProject.namespaceOf(namespace);
        this.name = StringUtils.trimToNull((String)name);
        this.type = type;
    }

    @Nonnull
    public static String namespaceOf(String value) {
        return StringUtils.upperCase((String)StringUtils.trimToNull((String)value), (Locale)Locale.ROOT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalProject) {
            InternalProject that = (InternalProject)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public ProjectType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public void initialize() {
    }

    public String toString() {
        return "Project{id=" + this.id + ", key='" + this.key + "', name='" + this.name + "'}";
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected int id;
        protected String namespace;

        public AbstractBuilder() {
            this.id = 0;
        }

        public AbstractBuilder(@Nonnull Project project) {
            this.id = ((Project)Preconditions.checkNotNull((Object)project, (Object)InternalProject.TABLE)).getId();
            this.namespace = project.getNamespace();
        }

        @Nonnull
        public B id(int value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public B namespace(String value) {
            this.namespace = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

