/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.task;

import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.task.Task;
import com.atlassian.bitbucket.task.TaskAnchor;
import com.atlassian.bitbucket.task.TaskOperations;
import com.atlassian.bitbucket.task.TaskState;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.property.AbstractPropertySupport;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="sta_task", indexes={@Index(name="idx_sta_task_anchor", columnList="anchor_type, anchor_id"), @Index(name="idx_sta_task_context", columnList="context_type, context_id")})
@TableGenerator(allocationSize=20, pkColumnValue="sta_task", name="entityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalTask
extends AbstractPropertySupport
implements Task,
Initializable {
    public static final String ID_GEN = "entityIdGenerator";
    public static final String TABLE = "sta_task";
    public static Function<Task, Long> TO_ID = new Function<Task, Long>(){

        public Long apply(Task input) {
            return input.getId();
        }
    };
    @JoinColumn(name="anchor_id", nullable=false, updatable=false)
    @Any(fetch=FetchType.LAZY, optional=false, metaColumn=@Column(name="anchor_type", nullable=false))
    @AnyMetaDef(idType="long", metaType="integer", metaValues={@MetaValue(targetEntity=InternalComment.class, value="1")})
    private TaskAnchor anchor;
    @JoinColumn(name="author_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_task_author"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser author;
    @JoinColumn(name="context_id", nullable=false, updatable=false)
    @Any(fetch=FetchType.LAZY, optional=false, metaColumn=@Column(name="context_type", nullable=false))
    @AnyMetaDef(idType="long", metaType="integer", metaValues={@MetaValue(targetEntity=InternalPullRequest.class, value="2")})
    private InternalTaskContext context;
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="entityIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Transient
    private TaskOperations permittedOperations;
    @Column(name="task_state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.task.TaskState")})
    private final TaskState state;
    @Column(name="task_text", nullable=false)
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String text;

    protected InternalTask() {
        this.anchor = null;
        this.author = null;
        this.context = null;
        this.createdDate = null;
        this.id = 0L;
        this.state = null;
        this.text = null;
    }

    private InternalTask(Builder builder) {
        super(builder);
        this.anchor = builder.anchor;
        this.author = builder.author;
        this.context = builder.context;
        this.createdDate = builder.createdDate;
        this.id = builder.id;
        this.state = builder.state;
        this.text = builder.text;
    }

    @Nonnull
    public TaskAnchor getAnchor() {
        return this.anchor;
    }

    @Nonnull
    public InternalApplicationUser getAuthor() {
        return this.author;
    }

    @Nonnull
    public InternalTaskContext getContext() {
        return this.context;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getId() {
        return this.id;
    }

    public TaskOperations getPermittedOperations() {
        return this.permittedOperations;
    }

    @Nonnull
    public TaskState getState() {
        return this.state;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Override
    public boolean hasProperties() {
        return super.hasProperties();
    }

    @Override
    public void initialize() {
        this.anchor = HibernateUtils.initialize(this.getAnchor());
        this.author = HibernateUtils.initialize(this.getAuthor());
        this.context = HibernateUtils.initialize(this.getContext());
    }

    public void setPermittedOperations(@Nonnull TaskOperations operations) {
        if (this.permittedOperations != null) {
            throw new IllegalStateException("permittedOperations has already been set");
        }
        this.permittedOperations = operations;
    }

    public static class Builder
    extends AbstractPropertySupport.PropertyBuilderSupport<Builder> {
        private TaskAnchor anchor;
        private InternalApplicationUser author;
        private InternalTaskContext context;
        private Date createdDate;
        private long id;
        private TaskState state = TaskState.OPEN;
        private String text;

        public Builder() {
            this.id = 0L;
        }

        public Builder(@Nonnull InternalTask task) {
            super((PropertySupport)Preconditions.checkNotNull((Object)task, (Object)"task"));
            this.anchor = task.getAnchor();
            this.author = task.getAuthor();
            this.context = task.getContext();
            this.createdDate = task.getCreatedDate();
            this.id = task.getId();
            this.state = task.getState();
            this.text = task.getText();
        }

        @Nonnull
        public Builder anchor(@Nonnull TaskAnchor value) {
            this.anchor = (TaskAnchor)Preconditions.checkNotNull((Object)value, (Object)"anchor");
            return this.self();
        }

        @Nonnull
        public Builder author(@Nonnull InternalApplicationUser value) {
            this.author = (InternalApplicationUser)Preconditions.checkNotNull((Object)value, (Object)"author");
            return this.self();
        }

        @Nonnull
        public InternalTask build() {
            return new InternalTask(this);
        }

        @Nonnull
        public Builder context(@Nonnull InternalTaskContext value) {
            this.context = (InternalTaskContext)Preconditions.checkNotNull((Object)value, (Object)"context");
            return this.self();
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            Date dateWithoutMs;
            Date dateWithMs = (Date)Preconditions.checkNotNull((Object)value, (Object)"createdDate");
            this.createdDate = dateWithoutMs = new Date(dateWithMs.getTime() / 1000L * 1000L);
            return this.self();
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public Builder state(@Nonnull TaskState value) {
            this.state = (TaskState)Preconditions.checkNotNull((Object)value, (Object)"state");
            return this.self();
        }

        @Nonnull
        public Builder text(@Nonnull String value) {
            this.text = Builder.checkNotBlank((String)value, (String)"text");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

