/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.idx.InternalIndexedCommit;
import com.atlassian.stash.internal.repository.InternalRepository;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="cs_repo_membership")
@IdClass(value=PK.class)
public class InternalRepositoryMembership
implements Initializable {
    @Id
    @JoinColumn(name="cs_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalIndexedCommit commit;
    @Id
    @JoinColumn(name="repository_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;

    protected InternalRepositoryMembership() {
        this.commit = null;
    }

    public InternalRepositoryMembership(@Nonnull InternalIndexedCommit commit, @Nonnull InternalRepository repository) {
        this.commit = commit;
        this.repository = repository;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InternalRepositoryMembership) {
            InternalRepositoryMembership that = (InternalRepositoryMembership)o;
            return Objects.equals(this.getCommit(), that.getCommit()) && Objects.equals(this.getRepository(), that.getRepository());
        }
        return false;
    }

    @Nonnull
    public InternalIndexedCommit getCommit() {
        return this.commit;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    public int hashCode() {
        return Objects.hash(this.getCommit(), this.getRepository());
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
    }

    public static class PK
    implements Serializable {
        private final String commit;
        private final int repository;

        public PK() {
            this(null, 0);
        }

        public PK(String commit, int repository) {
            this.commit = commit;
            this.repository = repository;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof PK) {
                PK pk = (PK)o;
                return Objects.equals(this.commit, pk.commit) && Objects.equals(this.repository, pk.repository);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.commit, this.repository);
        }
    }
}

