/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.participant.InternalAbstractParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="sta_pr_participant", indexes={@Index(name="idx_sta_pr_participant_pr", columnList="pr_id"), @Index(name="idx_sta_pr_participant_user", columnList="user_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_pr_participant_pr_user", columnNames={"pr_id", "user_id"})})
@TableGenerator(allocationSize=5, pkColumnValue="sta_pr_participant", name="entityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalPullRequestParticipant
extends InternalAbstractParticipant<InternalPullRequestParticipant>
implements PullRequestParticipant {
    public static final String TABLE = "sta_pr_participant";
    @Column(name="participant_status", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.pull.PullRequestParticipantStatus")})
    private final PullRequestParticipantStatus status;
    @JoinColumn(name="pr_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_pr_participant_pr"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalPullRequest pullRequest;
    @Column(name="pr_role", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.pull.PullRequestRole")})
    private final PullRequestRole role;

    protected InternalPullRequestParticipant() {
        this.pullRequest = null;
        this.role = null;
        this.status = PullRequestParticipantStatus.UNAPPROVED;
    }

    private InternalPullRequestParticipant(Builder builder) {
        super(builder);
        this.status = builder.status;
        this.pullRequest = builder.pullRequest;
        this.role = builder.role;
    }

    public int compareTo(@Nonnull PullRequestParticipant other) {
        if (this.getStatus().equals((Object)other.getStatus())) {
            return this.getUser().getDisplayName().compareTo(other.getUser().getDisplayName());
        }
        return this.isApproved() ? -1 : 1;
    }

    @Nonnull
    public InternalPullRequest getEntity() {
        return this.getPullRequest();
    }

    @Nonnull
    public InternalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public PullRequestRole getRole() {
        return this.role;
    }

    @Nonnull
    public PullRequestParticipantStatus getStatus() {
        return this.status;
    }

    @Override
    @Nonnull
    public InternalApplicationUser getUser() {
        return super.getUser();
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getPullRequest());
        super.initialize();
    }

    public boolean isApproved() {
        return this.status == PullRequestParticipantStatus.APPROVED;
    }

    public static class Builder
    extends InternalAbstractParticipant.AbstractParticipantBuilder<Builder, InternalPullRequestParticipant> {
        private final InternalPullRequest pullRequest;
        private PullRequestParticipantStatus status;
        private PullRequestRole role;

        public Builder(@Nonnull InternalPullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
            this.role = PullRequestRole.PARTICIPANT;
            this.status = PullRequestParticipantStatus.UNAPPROVED;
        }

        public Builder(@Nonnull InternalPullRequestParticipant participant) {
            super(participant);
            this.status = participant.getStatus();
            this.pullRequest = participant.getPullRequest();
            this.role = participant.getRole();
        }

        @Override
        @Nonnull
        public InternalPullRequestParticipant build() {
            return new InternalPullRequestParticipant(this);
        }

        @Nonnull
        public Builder role(@Nonnull PullRequestRole value) {
            this.role = Objects.requireNonNull(value, "role");
            return this.self();
        }

        @Nonnull
        public Builder status(@Nonnull PullRequestParticipantStatus value) {
            this.status = Objects.requireNonNull(value, "status");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

