/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.stash.internal.repository.InternalRepository;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="cs_indexer_state")
@IdClass(value=PK.class)
public class InternalIndexerState {
    public static final String TABLE = "cs_indexer_state";
    @Column(name="indexer_id")
    @NotEmpty
    @Id
    private final String indexerId;
    @Id
    @JoinColumn(name="repository_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalRepository repository;
    @Column(name="last_run")
    private final Long lastRun;

    protected InternalIndexerState() {
        this.indexerId = null;
        this.repository = null;
        this.lastRun = null;
    }

    public InternalIndexerState(@Nonnull String indexerId, @Nonnull InternalRepository repository, @Nullable Long lastRun) {
        this.indexerId = indexerId;
        this.repository = repository;
        this.lastRun = lastRun;
    }

    public String getIndexerId() {
        return this.indexerId;
    }

    public InternalRepository getRepository() {
        return this.repository;
    }

    public Long getLastRun() {
        return this.lastRun;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalIndexerState) {
            InternalIndexerState that = (InternalIndexerState)o;
            return Objects.equals(this.getIndexerId(), that.getIndexerId()) && Objects.equals(this.getRepository(), that.getRepository());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getIndexerId(), this.getRepository());
    }

    public static class PK
    implements Serializable {
        private final String indexerId;
        private final int repository;

        private PK() {
            this(null, 0);
        }

        public PK(String indexerId, int repository) {
            this.indexerId = indexerId;
            this.repository = repository;
        }

        public String getIndexerId() {
            return this.indexerId;
        }

        public int getRepositoryId() {
            return this.repository;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            return this.indexerId.equals(pk.indexerId) && this.repository == pk.repository;
        }

        public int hashCode() {
            int result = this.indexerId.hashCode();
            result = 31 * result + this.repository;
            return result;
        }
    }
}

