/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.config;

public enum RepoProperties {
    PULL_REQUEST_EVENT_ENABLED("pull-request.event.enabled", "true", Boolean.class),
    BRANCH_EVENT_ENABLED("branch.event.enabled", "true", Boolean.class),
    COMMIT_EVENT_ENABLED("commit.event.enabled", "true", Boolean.class);

    private String key;
    private String defaultValue;
    private Class type;

    private RepoProperties(String propertyKey, String defaultValue, Class type) {
        this.key = propertyKey;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Class getType() {
        return this.type;
    }

    public String toString() {
        return this.key;
    }

    public static RepoProperties getByKey(String otherKey) {
        for (RepoProperties p : RepoProperties.values()) {
            if (!p.getKey().equalsIgnoreCase(otherKey)) continue;
            return p;
        }
        return null;
    }
}

