function LookupResult(dataKey, value, settingsKey) {
    this.dataKey = dataKey;
    this.value = value;
    this.settingsKey = settingsKey || '';
    const within = AJS.I18n.getText('com.atlassian.plugins.dataeditor.label.in');
    const isSettingsKey = settingsKey && settingsKey !== '';
    this.displayKeysHtml = '<span id="data-key-result" class="pluginsettings-key">' + dataKey + '</span>' +
                           (isSettingsKey ? ' (' + within + ' <span id="settings-key-result">' + settingsKey +
                           '</span>)' : '');
    this.displayKeysNonHtml = dataKey + (isSettingsKey ? ' (' + within + ' ' + settingsKey + ')' : '');
}

// noinspection JSUnusedGlobalSymbols; used in onclick attributes below
function redoLookup(dataKey, settingsKey) {
    // toggle settings type dropdown & settings key field
    const settingsKeySelected = (AJS.$('#data-type option:selected').val() === "keyed-ps");
    if (settingsKey && settingsKey !== '') {
        if (!settingsKeySelected) {
            AJS.$('#data-type').val("keyed-ps");
        }
    }
    else {
        if (settingsKeySelected) {
            AJS.$('#data-type').val("global-ps");
        }
    }
    AJS.$('#settings-input').toggle(AJS.$('#data-type option:selected').val() === "keyed-ps");

    AJS.$('#settings-key-text').val(settingsKey);
    AJS.$('#data-key-text').val(dataKey);

    AJS.$('#data-key-submit').click();
}

function addToRecentLookupsList(lookupResult)
{
    if (jQuery.trim(lookupResult.value) === '' || isSearchHistoryBlank(lookupResult)) {
        return;
    }

    const lookupList = AJS.$('#recent-lookups');
    // if size is at least five, then remove oldest stored value
    const historySize = AJS.$('li', lookupList).length;
    if (historySize >= 5) {
        AJS.$('li:last', lookupList).remove();
    }
    lookupList.prepend('<li><span class="pluginsettings-key">' + lookupResult.displayKeysNonHtml +
            '</span><br><span class="pluginsettings-value">' + lookupResult.value +
            '</span> (<a href="#" onClick="redoLookup(\''+ lookupResult.dataKey + '\', \'' + lookupResult.settingsKey +
            '\');return true">' + AJS.I18n.getText('com.atlassian.plugins.dataeditor.history.redo') + '</a>)</li>');
}

function isSearchHistoryBlank(lookupResult) {
    // Check for the "empty state" translation and markup inserted by the Soy template
    return '<i>' + AJS.I18n.getText('com.atlassian.plugins.dataeditor.label.noresults') + '</i>' ===
        jQuery.trim(lookupResult.dataKey);
}

function showResult(lookupResult)
{
    const dataKeysElement = AJS.$('#data-keys');
    const dataKeyElement = AJS.$('#data-key-result');
    const settingsKeyElement = AJS.$('#settings-key-result');
    const redoButton = AJS.$('#data-redo-last');
    const container = AJS.$("#lookup-result-container");

    const prevLookupResult = new LookupResult(
        dataKeyElement.html(), container.html(), settingsKeyElement ? settingsKeyElement.html() : '');

    dataKeysElement.hide().html(lookupResult.displayKeysHtml);
    container.html(lookupResult.value);
    redoButton.attr("onClick",
        "redoLookup('" + lookupResult.dataKey + "','" + lookupResult.settingsKey + "');return true");

    // animate back with the new results
    dataKeysElement.fadeIn();
    container.fadeIn();
    redoButton.fadeIn();

    addToRecentLookupsList(prevLookupResult);
}

function clearData() {
    AJS.$('#data-key-text').val("");
    AJS.$('#settings-key-text').val("");
}

function getResult(data) {
    if (data == null || data === "") {
        return '<i>' + AJS.I18n.getText('com.atlassian.plugins.dataeditor.label.nodata') + '</i>';
    }
    return data.toString();
}

AJS.$(document).ready(function() {

    AJS.$("#keyed-ps").change(function() {
       AJS.$("#settings-key-group").toggle(AJS.$(this).attr("checked"));
    });

    AJS.$("#global-ps").change(function() {
        AJS.$("#settings-key-group").toggle(!AJS.$(this).attr("checked"));
    });

    // make pushing enter in the key input field submit the form
    AJS.$('#data-key-text').bind('keyup', function(e) {
        if (e.keyCode === 13) {
            AJS.$('#data-key-submit').click();
        }
    });

    // setting up clicking the lookup button to call to our rest resource
    AJS.$('#data-key-submit').click(function() {
        const dataKey = AJS.$('#data-key-text').val();
        const settingsKey = AJS.$('#settings-key-text').val();
        const url = AJS.contextPath() + '/rest/pde/1.0/' + (settingsKey !== '' ? settingsKey + '/' : '') + dataKey;
        // noinspection JSUnusedGlobalSymbols
        jQuery.ajax({
            url: url,
            // using complete instead of success and error, because i was getting a parsererror sometimes even though the status was OK
            complete: function(xhr, status) {
                let resultText;
                if (status === 'error' || !xhr.responseText) {
                    if (xhr.status === 404) {
                        resultText = '<i>' + AJS.I18n.getText('com.atlassian.plugins.dataeditor.results.none') + '</i>';
                    } else {
                        resultText = '<i>' + AJS.I18n.getText('com.atlassian.plugins.dataeditor.results.error') + '</i>';
                    }
                }
                else {
                    resultText = getResult(xhr.responseText);
                }
                showResult(new LookupResult(dataKey, resultText, settingsKey));
                clearData();
            }
        });
    });
});
