/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.depview.rest;

import com.atlassian.depview.osgi.BundleExplorer;
import com.atlassian.depview.osgi.WireDirection;
import com.atlassian.depview.rest.BundleBean;
import com.atlassian.depview.rest.BundleListBean;
import com.atlassian.depview.rest.PluginBean;
import com.atlassian.depview.rest.UriGenerator;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Singleton
@Path(value="/bundles")
public class BundlesResource {
    private final BundleContext bundleContext;
    private final UriGenerator uriGenerator;
    private final PluginAccessor pluginAccessor;

    @Inject
    public BundlesResource(BundleContext bundleContext, UriGenerator uriGenerator, PluginAccessor pluginAccessor) {
        this.bundleContext = bundleContext;
        this.uriGenerator = uriGenerator;
        this.pluginAccessor = pluginAccessor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getBundles(@QueryParam(value="q") String query) {
        Optional<String> q = query == null || query.equals("") ? Optional.empty() : Optional.of(query);
        return Response.ok((Object)new BundleListBean(this.uriGenerator, this.bundleContext, q)).build();
    }

    private Optional<Response> wrongBundleId(@Nonnull Long bundleId) {
        if (bundleId < 0L) {
            return Optional.of(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Wrong Bundle ID").build());
        }
        return Optional.empty();
    }

    private Optional<Response> bundleFound(@Nonnull Long bundleId, Function<Bundle, Response> action) {
        return Optional.ofNullable(this.bundleContext.getBundle(bundleId.longValue())).map(action);
    }

    private Response doWithBundleId(@Nonnull Long bundleId, Function<Bundle, Response> action) {
        return this.wrongBundleId(bundleId).orElse(this.bundleFound(bundleId, action).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND).build()));
    }

    @GET
    @Path(value="/{bundleId}")
    @Produces(value={"application/json"})
    public Response getBundle(@Nonnull @PathParam(value="bundleId") Long bundleId) {
        return this.doWithBundleId(bundleId, b -> Response.ok((Object)new BundleBean(this.uriGenerator, (Bundle)b, Optional.empty())).build());
    }

    @GET
    @Path(value="/{bundleId}/requiredWires")
    @Produces(value={"application/json"})
    public Response getRequiredWires(@Nonnull @PathParam(value="bundleId") Long bundleId) {
        return this.doWithBundleId(bundleId, b -> Response.ok(new BundleExplorer((Bundle)b).getWires(WireDirection.REQUIRED)).build());
    }

    @GET
    @Path(value="/{bundleId}/providedWires")
    @Produces(value={"application/json"})
    public Response getProvidedWires(@Nonnull @PathParam(value="bundleId") Long bundleId) {
        return this.doWithBundleId(bundleId, b -> Response.ok(new BundleExplorer((Bundle)b).getWires(WireDirection.PROVIDED)).build());
    }

    @GET
    @Path(value="/{bundleId}/servicesInUse")
    @Produces(value={"application/json"})
    public Response getServicesInUse(@Nonnull @PathParam(value="bundleId") Long bundleId) {
        return this.doWithBundleId(bundleId, b -> Response.ok(new BundleExplorer((Bundle)b).getServices(WireDirection.REQUIRED)).build());
    }

    @GET
    @Path(value="/{bundleId}/registeredServices")
    @Produces(value={"application/json"})
    public Response getRegisteredServices(@Nonnull @PathParam(value="bundleId") Long bundleId) {
        return this.doWithBundleId(bundleId, b -> Response.ok(new BundleExplorer((Bundle)b).getServices(WireDirection.PROVIDED)).build());
    }

    @GET
    @Path(value="/{bundleId}/declaredRequirements")
    @Produces(value={"application/json"})
    public Response getDeclaredRequirements(@Nonnull @PathParam(value="bundleId") Long bundleId) {
        return this.doWithBundleId(bundleId, b -> Response.ok(new BundleExplorer((Bundle)b).getDeclaredRequirements()).build());
    }

    @GET
    @Path(value="/{bundleId}/declaredCapabilities")
    @Produces(value={"application/json"})
    public Response getDeclaredCapabilities(@Nonnull @PathParam(value="bundleId") Long bundleId) {
        return this.doWithBundleId(bundleId, b -> Response.ok(new BundleExplorer((Bundle)b).getDeclaredCapabilities()).build());
    }

    @GET
    @Path(value="/{bundleId}/plugin")
    @Produces(value={"application/json"})
    public Response getPlugin(@Nonnull @PathParam(value="bundleId") Long bundleId) {
        return this.doWithBundleId(bundleId, b -> Response.ok((Object)new PluginBean(OsgiHeaderUtil.getPluginKey((Bundle)b), this.pluginAccessor)).build());
    }

    @GET
    @Path(value="/plugins")
    @Produces(value={"application/json"})
    public Response getToPlugins() {
        return Response.ok(Arrays.stream(this.bundleContext.getBundles()).collect(Collectors.toMap(Bundle::getBundleId, b -> new PluginBean(OsgiHeaderUtil.getPluginKey((Bundle)b), this.pluginAccessor)))).build();
    }
}

