/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.depview.rest;

import com.atlassian.depview.osgi.BundleExplorer;
import com.atlassian.depview.rest.DependencyBean;
import com.atlassian.depview.rest.ServiceSummaryBean;
import com.atlassian.depview.rest.UriGenerator;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.osgi.framework.Bundle;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class BundleBean {
    @XmlAttribute
    private final Long bundleId;
    @XmlAttribute
    private final BundleState state;
    @XmlElement
    private final Collection<DependencyBean> dependencies;
    @XmlElement
    private final ServiceSummaryBean services;
    @XmlElement
    private final Map<String, URI> links;

    public BundleBean(UriGenerator uriGenerator, Bundle bundle, Optional<String> query) {
        this.bundleId = bundle.getBundleId();
        this.state = BundleState.decode(bundle.getState());
        BundleExplorer bundleExplorer = new BundleExplorer(bundle, query);
        this.dependencies = bundleExplorer.getDependencies();
        this.services = new ServiceSummaryBean(bundleExplorer);
        this.links = Maps.newHashMap();
        this.links.put("self", uriGenerator.bundle(this.bundleId));
        Arrays.stream(new String[]{"providedWires", "requiredWires", "plugin", "servicesInUse", "registeredServices", "declaredCapabilities", "declaredRequirements"}).forEach(i -> this.links.put((String)i, uriGenerator.bundleInfo(this.bundleId, (String)i)));
    }

    private static enum BundleState {
        UNINSTALLED(1),
        INSTALLED(2),
        RESOLVED(4),
        STARTING(8),
        STOPPING(16),
        ACTIVE(32);

        private final int bundleState;

        private BundleState(int bundleState) {
            this.bundleState = bundleState;
        }

        public static BundleState decode(int state) {
            return Arrays.stream(BundleState.values()).filter(s -> state == s.bundleState).findAny().orElseThrow(() -> new IllegalStateException("Unrecognised state [" + state + "]"));
        }
    }
}

