AJS.$(document).ready(function () {

    console.log('Grabbing data from: ' + AJS.contextPath() + "/rest/depview/1.0/modules");

    AJS.$.get(AJS.contextPath() + "/rest/depview/1.0/modules", function (data) {

        var jqData = data.map((el) => {
            return [
                el.pluginName,
                el.moduleKey,
                el.moduleClass,
                el.moduleState
            ];
        });

        var oTable = AJS.$('#modules-table').DataTable(
            {
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "All"]],
                "pageLength": 100,
                "iDisplayLength": 10,
                "columns": [
                    "pluginName",
                    "moduleKey",
                    "moduleClass",
                    "moduleState"
                ]
            }
        );

        oTable.fnAddData(jqData);

        var asInitVals = new Array();

        AJS.$('#modules-table tfoot th').each( function () {
            var title = AJS.$(this).text();
            AJS.$(this).html( '<input type="text" placeholder="Search '+title+'" />' );
        } );

        AJS.$("tfoot input").keyup( function () {
            /* Filter on the column (the index) of this element */
            oTable.fnFilter( this.value, AJS.$("tfoot input").index(this) );
        } );

        /*
         * Support functions to provide a little bit of 'user friendlyness' to the textboxes in
         * the footer
         */
        AJS.$("tfoot input").each( function (i) {
            asInitVals[i] = this.value;
        } );

        AJS.$("tfoot input").focus( function () {
            if ( this.className == "search_init" )
            {
                this.className = "";
                this.value = "";
            }
        } );

        AJS.$("tfoot input").blur( function (i) {
            if ( this.value == "" )
            {
                this.className = "search_init";
                this.value = asInitVals[AJS.$("tfoot input").index(this)];
            }
        } );
    });
});
