/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.depview.rest;

import com.atlassian.depview.rest.ModuleBean;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Singleton
@Path(value="/modules")
public class ModulesResource {
    private final PluginAccessor pluginAccessor;

    @Inject
    public ModulesResource(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getBundles(@QueryParam(value="q") String query) {
        Collection modules = this.pluginAccessor.getModuleDescriptors(objectModuleDescriptor -> true);
        Stream<ModuleBean> moduleBeanStream = modules.stream().map(m -> new ModuleBean(m.getPluginKey(), m.getPlugin().getName(), m.getKey(), m.getName(), m.getModuleClass(), this.pluginAccessor.isPluginModuleEnabled(m.getCompleteKey())));
        return Response.ok(moduleBeanStream.collect(Collectors.toList())).build();
    }
}

