/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pdkinstall;

import com.atlassian.pdkinstall.PluginInstaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PdkInstallFilter
implements Filter {
    private final FileItemFactory factory;
    private final PluginInstaller pluginInstaller;
    private static final Log log = LogFactory.getLog(PdkInstallFilter.class);

    public PdkInstallFilter(PluginInstaller pluginInstaller) {
        this.pluginInstaller = pluginInstaller;
        this.factory = new DiskFileItemFactory();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        if (!req.getMethod().equalsIgnoreCase("post")) {
            res.sendError(400, "Requires post");
            return;
        }
        File tmp = null;
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        tmp = isMultipart ? this.extractJar(req, res, tmp) : this.buildJarFromFiles(req);
        if (tmp != null) {
            ArrayList<String> errors = new ArrayList<String>();
            try {
                errors.addAll(this.pluginInstaller.install(tmp));
            }
            catch (Exception ex) {
                log.error((Object)ex);
                errors.add(ex.getMessage());
            }
            tmp.delete();
            if (errors.isEmpty()) {
                res.setStatus(200);
                servletResponse.setContentType("text/plain");
                servletResponse.getWriter().println("Installed plugin " + tmp.getPath());
            } else {
                res.setStatus(400);
                servletResponse.setContentType("text/plain");
                servletResponse.getWriter().println("Unable to install plugin:");
                for (String err : errors) {
                    servletResponse.getWriter().println("\t - " + err);
                }
            }
            servletResponse.getWriter().close();
            return;
        }
        res.sendError(400, "Missing plugin file");
    }

    private File extractJar(HttpServletRequest req, HttpServletResponse res, File tmp) throws IOException {
        ServletFileUpload upload = new ServletFileUpload(this.factory);
        try {
            List items = upload.parseRequest(req);
            for (FileItem item : items) {
                if (!item.getFieldName().startsWith("file_") || item.isFormField()) continue;
                tmp = File.createTempFile("plugindev-", item.getName());
                tmp.renameTo(new File(tmp.getParentFile(), item.getName()));
                item.write(tmp);
            }
        }
        catch (FileUploadException e) {
            log.warn((Object)e, (Throwable)e);
            res.sendError(400, "Unable to process file upload");
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
            res.sendError(500, "Unable to process file upload");
        }
        return tmp;
    }

    private File buildJarFromFiles(HttpServletRequest req) throws IOException {
        File tmp = File.createTempFile("plugindev-", ".jar");
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(tmp));
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("fileName_")) continue;
            String id = name.substring("fileName_".length());
            String fileName = req.getParameter(name);
            String fileData = req.getParameter("file_" + id);
            ZipEntry entry = new ZipEntry(fileName);
            zout.putNextEntry(entry);
            IOUtils.copy((Reader)new StringReader(fileData), (OutputStream)zout);
        }
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        zout.putNextEntry(entry);
        IOUtils.copy((Reader)new StringReader("Manifest-Version: 1.0\n\n"), (OutputStream)zout);
        zout.close();
        return tmp;
    }

    public void destroy() {
    }
}

