/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pdkinstall;

import com.atlassian.plugin.DefaultPluginArtifactFactory;
import com.atlassian.plugin.PluginArtifactFactory;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.util.zip.FileUnzipper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObrPluginTypeInstaller {
    private final RepositoryAdmin repositoryAdmin;
    private final PluginController pluginController;
    private final PluginArtifactFactory pluginArtifactFactory = new DefaultPluginArtifactFactory();

    public ObrPluginTypeInstaller(PluginController pluginController, BundleContext bundleContext) {
        this.pluginController = pluginController;
        ServiceReference ref = bundleContext.getServiceReference(RepositoryAdmin.class.getName());
        this.repositoryAdmin = (RepositoryAdmin)bundleContext.getService(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(File plugin, List<String> errors) throws Exception {
        File obrDir = this.expandObrFile(plugin);
        URL repoUrl = new File(obrDir, "obr.xml").toURI().toURL();
        try {
            this.repositoryAdmin.addRepository(repoUrl);
            Resolver resolver = this.repositoryAdmin.resolver();
            List<File> pluginsToInstall = this.findPluginsToInstall(obrDir);
            for (File pluginJar : pluginsToInstall) {
                String bundleName = this.extractBundleName(pluginJar);
                Resource resource = this.repositoryAdmin.discoverResources("(symbolicname=" + bundleName + ")")[0];
                resolver.add(resource);
            }
            if (resolver.resolve()) {
                this.installResources(resolver);
            } else {
                for (Requirement req : resolver.getUnsatisfiedRequirements()) {
                    errors.add("Unable to resolve: " + req.getName() + " - " + req.getComment() + " filter: " + req.getFilter());
                }
            }
        }
        finally {
            this.repositoryAdmin.removeRepository(repoUrl);
            FileUtils.deleteDirectory((File)obrDir);
        }
    }

    private void installResources(Resolver resolver) throws URISyntaxException {
        for (Resource res : resolver.getRequiredResources()) {
            this.pluginController.installPlugin(this.pluginArtifactFactory.create(res.getURL().toURI()));
        }
        for (Resource res : resolver.getAddedResources()) {
            this.pluginController.installPlugin(this.pluginArtifactFactory.create(res.getURL().toURI()));
        }
        for (Resource res : resolver.getOptionalResources()) {
            this.pluginController.installPlugin(this.pluginArtifactFactory.create(res.getURL().toURI()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractBundleName(File pluginJar) throws IOException {
        JarFile jar = null;
        try {
            jar = new JarFile(pluginJar);
            String string = jar.getManifest().getMainAttributes().getValue("Bundle-SymbolicName");
            return string;
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private List<File> findPluginsToInstall(File obrDir) {
        return Arrays.asList(obrDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        }));
    }

    private File expandObrFile(File plugin) throws IOException {
        File dir = File.createTempFile("obr-", plugin.getName());
        dir.delete();
        dir.mkdir();
        FileUnzipper unzipper = new FileUnzipper(plugin, dir);
        unzipper.unzip();
        return dir;
    }
}

