/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.internal.BaseManagementPlugin;
import org.osgi.service.startlevel.StartLevel;

public class SetStartLevelAction
extends BaseManagementPlugin
implements Action {
    public static final String NAME = "setStartLevel";
    public static final String LABEL = "Set Start Level";

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return LABEL;
    }

    public boolean performAction(HttpServletRequest request, HttpServletResponse response) {
        StartLevel sl = this.getStartLevel();
        if (sl != null) {
            int systemSL;
            int bundleSL = this.getParameterInt(request, "bundleStartLevel");
            if (bundleSL > 0 && bundleSL != sl.getInitialBundleStartLevel()) {
                sl.setInitialBundleStartLevel(bundleSL);
            }
            if ((systemSL = this.getParameterInt(request, "systemStartLevel")) > 0 && systemSL != sl.getStartLevel()) {
                sl.setStartLevel(systemSL);
            }
        }
        return true;
    }

    private int getParameterInt(HttpServletRequest request, String name) {
        try {
            return Integer.parseInt(request.getParameter(name));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

