/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.position;

import org.osgi.util.measurement.Measurement;
import org.osgi.util.measurement.Unit;

public class Position {
    private Measurement altitude;
    private Measurement longitude;
    private Measurement latitude;
    private Measurement speed;
    private Measurement track;
    private static final double LON_RANGE = Math.PI;
    private static final double LAT_RANGE = 1.5707963267948966;
    private static final double TRACK_RANGE = Math.PI * 2;

    public Position(Measurement lat, Measurement lon, Measurement alt, Measurement speed, Measurement track) {
        if (lat != null) {
            if (!Unit.rad.equals(lat.getUnit())) {
                throw new IllegalArgumentException("Invalid Latitude");
            }
            this.latitude = lat;
        }
        if (lon != null) {
            if (!Unit.rad.equals(lon.getUnit())) {
                throw new IllegalArgumentException("Invalid Longitude");
            }
            this.longitude = lon;
        }
        this.normalizeLatLon();
        if (alt != null) {
            if (!Unit.m.equals(alt.getUnit())) {
                throw new IllegalArgumentException("Invalid Altitude");
            }
            this.altitude = alt;
        }
        if (speed != null) {
            if (!Unit.m_s.equals(speed.getUnit())) {
                throw new IllegalArgumentException("Invalid Speed");
            }
            this.speed = speed;
        }
        if (track != null) {
            if (!Unit.rad.equals(track.getUnit())) {
                throw new IllegalArgumentException("Invalid Track");
            }
            this.track = this.normalizeTrack(track);
        }
    }

    public Measurement getAltitude() {
        return this.altitude;
    }

    public Measurement getLongitude() {
        return this.longitude;
    }

    public Measurement getLatitude() {
        return this.latitude;
    }

    public Measurement getSpeed() {
        return this.speed;
    }

    public Measurement getTrack() {
        return this.track;
    }

    private void normalizeLatLon() {
        if (this.longitude == null || this.latitude == null) {
            return;
        }
        double dlon = this.longitude.getValue();
        double dlat = this.latitude.getValue();
        if (dlon >= -Math.PI && dlon < Math.PI && dlat >= -1.5707963267948966 && dlat <= 1.5707963267948966) {
            return;
        }
        dlon = this.normalize(dlon, Math.PI);
        if ((dlat = this.normalize(dlat, Math.PI)) > 1.5707963267948966 || dlat < -1.5707963267948966) {
            dlon = this.normalize(dlon - Math.PI, Math.PI);
            dlat = this.normalize(Math.PI - dlat, 1.5707963267948966);
        }
        this.longitude = new Measurement(dlon, this.longitude.getError(), this.longitude.getUnit(), this.longitude.getTime());
        this.latitude = new Measurement(dlat, this.latitude.getError(), this.latitude.getUnit(), this.latitude.getTime());
    }

    private double normalize(double value, double range) {
        double twiceRange = 2.0 * range;
        while (value >= range) {
            value -= twiceRange;
        }
        while (value < -range) {
            value += twiceRange;
        }
        return value;
    }

    private Measurement normalizeTrack(Measurement track) {
        double value = track.getValue();
        if (0.0 <= value && value < Math.PI * 2) {
            return track;
        }
        if ((value %= Math.PI * 2) < 0.0) {
            value += Math.PI * 2;
        }
        return new Measurement(value, track.getError(), track.getUnit(), track.getTime());
    }
}

