/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.user;

import com.atlassian.bitbucket.test.rest.RestPagedRequest;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RestUsersRequest
extends RestPagedRequest {
    private final String filter;
    private final String group;
    private final Map<String, String> permissionParams;

    private RestUsersRequest(Builder builder) {
        super(builder);
        this.filter = builder.filter;
        this.group = builder.group;
        this.permissionParams = builder.permissionParams;
    }

    @Override
    @Nonnull
    public Map<String, Object> toQueryParams() {
        LinkedHashMap params = Maps.newLinkedHashMap(super.toQueryParams());
        if (StringUtils.isNotBlank((CharSequence)this.filter)) {
            params.put("filter", this.filter);
        }
        if (StringUtils.isNotBlank((CharSequence)this.group)) {
            params.put("group", this.group);
        }
        params.putAll(this.permissionParams);
        return params;
    }

    public static class Builder
    extends RestPagedRequest.AbstractPagedRequestBuilder<Builder, RestPagedRequest> {
        private final Map<String, String> permissionParams = Maps.newHashMap();
        private String filter;
        private String group;

        public Builder() {
        }

        public Builder(@Nonnull RestPagedRequest request) {
            super(request);
        }

        @Nonnull
        public Builder filter(@Nullable String filter) {
            this.filter = filter;
            return this;
        }

        @Nonnull
        public Builder group(@Nullable String group) {
            this.group = group;
            return this;
        }

        @Nonnull
        public Builder permission(@Nonnull String permissionName) {
            Objects.requireNonNull(permissionName, "permissionName");
            this.permissionParams.put("permission", permissionName);
            return this;
        }

        @Nonnull
        public Builder permission(int index, @Nonnull String permissionName) {
            this.checkIndex(index);
            Objects.requireNonNull(permissionName, "permissionName");
            this.permissionParams.put("permission." + index, permissionName);
            return this;
        }

        @Nonnull
        public Builder permissionResource(@Nonnull String resourceKey, @Nonnull String resourceValue) {
            Objects.requireNonNull(resourceKey, "resourceKey");
            Objects.requireNonNull(resourceValue, "resourceValue");
            this.permissionParams.put("permission." + resourceKey, resourceValue);
            return this;
        }

        @Nonnull
        public Builder permissionResource(int index, @Nonnull String resourceKey, @Nonnull String resourceValue) {
            this.checkIndex(index);
            Objects.requireNonNull(resourceKey, "resourceKey");
            Objects.requireNonNull(resourceValue, "resourceValue");
            this.permissionParams.put("permission." + index + "." + resourceKey, resourceValue);
            return this;
        }

        @Override
        @Nonnull
        public RestUsersRequest build() {
            return new RestUsersRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        private void checkIndex(int index) {
            Preconditions.checkArgument((index > 0 ? 1 : 0) != 0, (Object)"Index must be >0");
        }
    }
}

