/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.server.stub.mirror;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.wiremock.WiremockTestUtils;
import com.atlassian.httpclient.api.Request;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.JwtClaimsBuilder;
import com.atlassian.jwt.core.writer.NimbusJwtWriterFactory;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.jwt.writer.JwtWriterFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorStub {
    private static final Logger log = LoggerFactory.getLogger(MirrorStub.class);
    private static final String type = "single";
    private final String id;
    private final JwtWriterFactory jwtWriter;
    private final String serverId;
    private final WireMockServer wireMock;
    private volatile String sharedSecret;

    private MirrorStub(WireMockServer wireMockServer) {
        this.wireMock = wireMockServer;
        this.serverId = UUID.randomUUID().toString();
        this.id = this.serverId.toUpperCase(Locale.ROOT);
        this.jwtWriter = new NimbusJwtWriterFactory();
    }

    public static MirrorStub aStub(WireMockServer wiremock) {
        return new MirrorStub(wiremock);
    }

    public static String joinUrlAndPath(String baseUrl, String path) {
        return String.format("%s%s", baseUrl, StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    public MirrorStub configureDefaultResponders() {
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)this.getUninstalledPath())).willReturn(WireMock.aResponse().withStatus(Response.Status.OK.getStatusCode())));
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)this.getWebhookEventsPath())).willReturn(WireMock.aResponse().withStatus(Response.Status.OK.getStatusCode())));
        this.wireMock.stubFor(WireMock.requestMatching(request -> {
            if (request.getUrl().contains(this.getInstalledPath())) {
                try {
                    Map properties = (Map)new ObjectMapper().readValue(request.getBodyAsString(), Map.class);
                    String sharedSecretProperty = (String)properties.get("sharedSecret");
                    if (sharedSecretProperty == null) {
                        log.error("No shared secret found during stub mirror install callback. Request body:\n{}", (Object)request.getBody());
                    }
                    this.sharedSecret = sharedSecretProperty;
                }
                catch (IOException e) {
                    log.error("Failed to capture shared secret during stub mirror install callback. Request body:\n{}", (Object)request.getBodyAsString(), (Object)e);
                }
                return MatchResult.of((boolean)true);
            }
            return MatchResult.of((boolean)false);
        }).willReturn(WireMock.aResponse().withStatus(Response.Status.OK.getStatusCode())));
        return this;
    }

    public String getBaseUrl() {
        return this.wireMock.baseUrl();
    }

    public String getId() {
        return this.id;
    }

    public String getInstalledPath() {
        return "/rest/mirroring/latest/lifecycle/installed";
    }

    public String getType() {
        return type;
    }

    public String getUninstalledPath() {
        return "/rest/mirroring/latest/lifecycle/uninstalled";
    }

    public String getUrl(String path) {
        return MirrorStub.joinUrlAndPath(this.getBaseUrl(), path);
    }

    public String getWebhookEventsPath() {
        return "/rest/mirroring/latest/webhookEvents";
    }

    public String signRequest(Request.Method method, String baseUrl, String requestUrl) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return this.signRequest(method, baseUrl, requestUrl, Collections.emptyMap());
    }

    public String signRequest(@Nonnull Request.Method method, @Nonnull String baseUrl, @Nonnull String requestUrl, @Nonnull Map<String, String[]> parameters) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (this.sharedSecret == null) {
            throw new IllegalStateException("This mirror has not been installed or the install request was not captured");
        }
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(baseUrl, "baseUrl");
        Objects.requireNonNull(requestUrl, "requestUrl");
        Preconditions.checkArgument((boolean)requestUrl.startsWith(baseUrl), (Object)"requestUrl must start with baseUrl");
        String relativeUrl = requestUrl.substring(DefaultFuncTestData.getBaseURL().length());
        CanonicalHttpUriRequest canonical = new CanonicalHttpUriRequest(method.name(), relativeUrl, "", parameters);
        long issuedAt = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        long expiresAt = issuedAt + 180L;
        JwtJsonBuilder jwtBuilder = new JsonSmartJwtJsonBuilder().issuedAt(issuedAt).expirationTime(expiresAt).issuer(this.id.toUpperCase(Locale.ROOT));
        JwtClaimsBuilder.appendHttpRequestClaims((JwtJsonBuilder)jwtBuilder, (CanonicalHttpRequest)canonical);
        return this.jwtWriter.macSigningWriter(SigningAlgorithm.HS256, this.sharedSecret).jsonToJwt(jwtBuilder.build());
    }

    public void waitForInstallation() {
        WiremockTestUtils.waitForRequest((WireMockServer)this.wireMock, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)this.getInstalledPath())));
    }
}

