/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.migration;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.dmz.rest.v2.job.RestJobMessage;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.PullRequestTestHelper;
import com.atlassian.bitbucket.test.RepositoryTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.repository.sync.RestGetRefSyncStatusRequest;
import com.atlassian.bitbucket.test.rest.repository.sync.RestRefSyncHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import io.restassured.RestAssured;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.ResponseSpecification;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestMigrationHelper
extends AbstractRestHelper {
    public static final Map<String, String> REF_TYPE_TO_STATE_MAP = ImmutableMap.of((Object)"divergedRefs", (Object)"DIVERGED", (Object)"aheadRefs", (Object)"AHEAD");
    private static final Pattern ATTACHMENT_PATTERN = Pattern.compile("(\\(attachment:)\\d+/.*?(\\))");
    private static final Logger log = LoggerFactory.getLogger(RestMigrationHelper.class);

    public RestMigrationHelper() {
        this(DefaultFuncTestData.getAdminAuthentication());
    }

    public RestMigrationHelper(@Nullable RestAuthentication defaultAuthentication) {
        super(defaultAuthentication);
    }

    public static void assertExportJobState(int jobId, org.hamcrest.Matcher<JobState> state) {
        RestMigrationHelper.assertJobState(state, RestMigrationHelper.getFailureStateMatcher(state), RestMigrationHelper.getExportJobUrl(jobId));
    }

    public static void assertImportJobState(int jobId, org.hamcrest.Matcher<JobState> state) {
        RestMigrationHelper.assertJobState(state, RestMigrationHelper.getFailureStateMatcher(state), RestMigrationHelper.getImportJobUrl(jobId));
    }

    public static void assertJobState(final org.hamcrest.Matcher<JobState> successState, final org.hamcrest.Matcher<JobState> errorState, final String jobUrl) {
        final int waitTimeInMs = 120000;
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){
            private Object currentState;

            public void describeFailure(Description description) {
                description.appendText("Export state != " + successState + " after " + waitTimeInMs + " ms; the current state is " + this.currentState);
            }

            public boolean test() {
                Response response = (Response)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).when().get(jobUrl, new Object[0])).then()).log().ifValidationFails()).statusCode(Response.Status.OK.getStatusCode())).extract().response();
                this.currentState = JobState.valueOf((String)((String)response.path("state", new String[0])));
                if (errorState.matches(this.currentState)) {
                    StringDescription desc = new StringDescription();
                    errorState.describeTo((Description)desc);
                    StringBuilder buf = new StringBuilder();
                    buf.append("Job is in state ").append(this.currentState).append(", which matches error condition ").append(desc.toString());
                    this.appendJobLogMessages(buf);
                    Assert.fail((String)buf.toString());
                }
                return successState.matches(this.currentState);
            }

            private void appendJobLogMessages(StringBuilder buf) {
                try {
                    Stream<RestJobMessage> messageStream = ((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(RestMigrationHelper.getJobMessagesUrl(jobUrl), new Object[0])).then()).extract().jsonPath().getList("values", Map.class).stream().map(RestJobMessage::new);
                    List<RestJobMessage> messages = messageStream.collect(Collectors.toList());
                    if (!messages.isEmpty()) {
                        buf.append("\n\nJob has the following error messages:\n");
                        messages.forEach(jobMessage -> buf.append(" * ").append(jobMessage.getSeverity()).append(" [").append(jobMessage.getSubject()).append("]: ").append(jobMessage.getText()).append("\n"));
                    }
                }
                catch (RuntimeException e) {
                    log.info("Error while getting job messages", (Throwable)e);
                }
            }
        }, (long)waitTimeInMs);
    }

    public static InputStream downloadArchive(int id) {
        return ((Response)((ResponseSpecification)RestAssured.given().expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(DefaultFuncTestData.getBaseURL() + "/rest/dcm-test-util/latest/migration-archive/" + id, new Object[0])).asInputStream();
    }

    public static int exportRepositories(List<Map<String, String>> selectors) {
        int jobId = (Integer)((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body((Object)ImmutableMap.builder().put((Object)"repositoriesRequest", (Object)ImmutableMap.of((Object)"includes", selectors)).build()).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().post(RestMigrationHelper.getExportUrl(), new Object[0])).then()).extract().path("id", new String[0]);
        log.info("Started export job with ID {}", (Object)jobId);
        return jobId;
    }

    public static int exportRepositoriesAndWait(List<Map<String, String>> selectors) {
        int jobId = RestMigrationHelper.exportRepositories(selectors);
        RestMigrationHelper.assertExportJobState(jobId, (org.hamcrest.Matcher<JobState>)Matchers.is((Object)JobState.COMPLETED));
        return jobId;
    }

    public static String getCommitsUrl(String projectKey, String repositorySlug) {
        return DefaultFuncTestData.getRepositoryRestURL(projectKey, repositorySlug) + "/commits";
    }

    public static String getExportJobMessagesUrl(int jobId) {
        return RestMigrationHelper.getJobMessagesUrl(RestMigrationHelper.getExportJobUrl(jobId));
    }

    public static String getExportJobUrl(int jobId) {
        return DefaultFuncTestData.getRestURL() + "/migration/exports/" + jobId;
    }

    public static String getExportPreviewUrl() {
        return DefaultFuncTestData.getRestURL() + "/migration/exports/preview";
    }

    public static String getExportUrl() {
        return DefaultFuncTestData.getRestURL() + "/migration/exports";
    }

    public static String getImportJobMessagesUrl(int jobId) {
        return RestMigrationHelper.getJobMessagesUrl(RestMigrationHelper.getImportJobUrl(jobId));
    }

    public static String getImportJobUrl(int jobId) {
        return DefaultFuncTestData.getRestURL() + "/migration/imports/" + jobId;
    }

    public static String getImportUrl() {
        return DefaultFuncTestData.getRestURL() + "/migration/imports";
    }

    public static String getJobMessagesUrl(String jobUrl) {
        return jobUrl + "/messages";
    }

    public static int importRepositories(int id) {
        int jobId = (Integer)((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body((Object)ImmutableMap.of((Object)"archivePath", (Object)("Bitbucket_export_" + id + ".tar"))).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().post(RestMigrationHelper.getImportUrl(), new Object[0])).then()).extract().path("id", new String[0]);
        log.info("Started import job with ID {}", (Object)jobId);
        return jobId;
    }

    public static int importRepositoriesAndWait(int id) {
        int jobId = RestMigrationHelper.importRepositories(id);
        RestMigrationHelper.assertImportJobState(jobId, (org.hamcrest.Matcher<JobState>)Matchers.is((Object)JobState.COMPLETED));
        return jobId;
    }

    public static TypeSafeDiagnosingMatcher<List<Map<String, Object>>> matchesRestJobMessages(final org.hamcrest.Matcher<Iterable<? extends RestJobMessage>> messages) {
        return new TypeSafeDiagnosingMatcher<List<Map<String, Object>>>(){

            public void describeTo(Description description) {
                messages.describeTo(description);
            }

            protected boolean matchesSafely(List<Map<String, Object>> item, Description mismatchDescription) {
                List mappedMessages = item.stream().map(RestJobMessage::new).collect(Collectors.toList());
                if (!messages.matches(mappedMessages)) {
                    mismatchDescription.appendDescriptionOf((SelfDescribing)messages).appendText(" ");
                    messages.describeMismatch(mappedMessages, mismatchDescription);
                    return false;
                }
                return true;
            }
        };
    }

    public static void moveArchiveFromExportToImport(int id) {
        ((ResponseSpecification)RestAssured.given().expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(DefaultFuncTestData.getBaseURL() + "/rest/dcm-test-util/latest/migration-archive/" + id + "/move", new Object[0]);
    }

    public static List<Map<String, Object>> previewExport(List<Map<String, String>> selectors) {
        return ((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body((Object)ImmutableMap.builder().put((Object)"repositoriesRequest", (Object)ImmutableMap.of((Object)"includes", selectors)).build()).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().post(RestMigrationHelper.getExportPreviewUrl(), new Object[0])).then()).extract().body().jsonPath().getList("scopes");
    }

    public static WaitCondition pullRequestActivity(final PullRequestTestHelper pullRequest, final org.hamcrest.Matcher<PullRequestAction> action) {
        return new WaitCondition(){

            public void describeFailure(Description description) {
                action.describeTo(description);
            }

            public boolean test() {
                return action.matches((Object)PullRequestAction.valueOf((String)pullRequest.getActivities().get("values[0].action").toString()));
            }
        };
    }

    public static void pushCommits(String projectKey, String repoSlug, String branch) throws IOException, URISyntaxException {
        String commit = RepositoryTestHelper.pushCommits(DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), projectKey, repoSlug, branch, "Author", "author@example.com", "test", "file", "content", String.format("Commit to %s/%s - %s", projectKey, repoSlug, branch), 10, 10);
        RestMigrationHelper.waitUntilVerified(() -> ((ValidatableResponse)RepositoryTestHelper.getRepository("/projects/" + projectKey + "/repos/" + repoSlug + "/commits?until=refs/heads/" + branch + "&limit=1").then()).body("values[0].id", Matchers.equalTo((Object)commit), new Object[0]), 5000L);
    }

    public static void uploadArchive(InputStream stream, int id) {
        ((ResponseSpecification)RestAssured.given().contentType("application/octet-stream").body(stream).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().put(DefaultFuncTestData.getBaseURL() + "/rest/dcm-test-util/latest/migration-archive/" + id, new Object[0]);
    }

    public static void verifyAttachment(String attachmentFilename, PullRequestTestHelper pullRequest) {
        Map<String, String> attachments = RestMigrationHelper.getAttachments(pullRequest);
        String attachmentUrl = attachments.get(attachmentFilename);
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().head(URI.create(DefaultFuncTestData.getBaseURL()).resolve(attachmentUrl).toString(), new Object[0]);
    }

    public static void verifyForkSyncEnabled(RestRefSyncHelper refSyncHelper, List<String> aheadBranchNames, List<String> divergedBranchNames) {
        ResponseSpecBuilder responseSpec = new ResponseSpecBuilder().expectBody("enabled", Matchers.equalTo((Object)true)).expectBody("aheadRefs", Matchers.hasSize((int)aheadBranchNames.size())).expectBody("divergedRefs", Matchers.hasSize((int)divergedBranchNames.size())).expectBody("orphanedRefs", Matchers.empty());
        ImmutableMap.of((Object)"divergedRefs", divergedBranchNames, (Object)"aheadRefs", aheadBranchNames).forEach((refType, branchNames) -> {
            Object[] maps = (Map[])branchNames.stream().map(branchName -> ImmutableMap.of((Object)"id", (Object)("refs/heads/" + branchName), (Object)"displayId", (Object)branchName, (Object)"state", (Object)((Serializable)((Object)REF_TYPE_TO_STATE_MAP.get(refType))), (Object)"tag", (Object)false, (Object)"type", (Object)"BRANCH")).toArray(Map[]::new);
            responseSpec.expectBody(refType, Matchers.containsInAnyOrder((Object[])maps));
        });
        refSyncHelper.getStatus(((RestGetRefSyncStatusRequest.Builder)new RestGetRefSyncStatusRequest.Builder().specification(responseSpec.build())).build());
    }

    public static void verifyForkSyncFlagDisabled(RestRefSyncHelper refSyncHelper) {
        refSyncHelper.getStatus(((RestGetRefSyncStatusRequest.Builder)new RestGetRefSyncStatusRequest.Builder().specification(new ResponseSpecBuilder().expectBody("enabled", Matchers.equalTo((Object)false)).build())).build());
    }

    public static void verifyJobMessages(String jobMessagesUrl, org.hamcrest.Matcher<Iterable<? extends RestJobMessage>> messages) {
        ((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(jobMessagesUrl, new Object[0])).then()).body("values", RestMigrationHelper.matchesRestJobMessages(messages), new Object[0]);
    }

    public static void verifyNoJobMessages(String jobMessagesUrl) {
        ((ValidatableResponse)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(jobMessagesUrl, new Object[0])).then()).body("values", Matchers.empty(), new Object[0]);
    }

    public static void waitUntilVerified(final Runnable assertion, long timeoutMs) {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){
            private Throwable error;

            public void describeFailure(Description description) {
                if (this.error instanceof AssertionError) {
                    throw (AssertionError)((Object)this.error);
                }
                if (this.error instanceof RuntimeException) {
                    throw (RuntimeException)this.error;
                }
                throw new RuntimeException(this.error);
            }

            public boolean test() {
                try {
                    assertion.run();
                    return true;
                }
                catch (AssertionError | RuntimeException e) {
                    this.error = e;
                    return false;
                }
            }
        }, (long)timeoutMs, (long)500L);
    }

    private static Map<String, String> getAttachments(PullRequestTestHelper pr) {
        ImmutableMap.Builder attachments = ImmutableMap.builder();
        Matcher m = Pattern.compile("(?s)<img(?:\\s+src=\"(?<src>[^\"]+)\"|\\s+alt=\"(?<alt>[^\"]+)\")*\\s*/?>").matcher(pr.getWithMarkup().getString("descriptionAsHtml"));
        while (m.find()) {
            attachments.put((Object)m.group("alt"), (Object)m.group("src"));
        }
        return attachments.build();
    }

    private static org.hamcrest.Matcher<JobState> getFailureStateMatcher(org.hamcrest.Matcher<JobState> state) {
        return Matchers.allOf((org.hamcrest.Matcher)Matchers.not(state), (org.hamcrest.Matcher)new TypeSafeDiagnosingMatcher<JobState>(){

            public void describeTo(Description description) {
                description.appendText("is terminated");
            }

            protected boolean matchesSafely(JobState item, Description mismatchDescription) {
                return item.isTerminated();
            }
        });
    }

    public static org.hamcrest.Matcher<RestJobMessage> jobMessage(org.hamcrest.Matcher<JobMessageSeverity> severity, org.hamcrest.Matcher<String> subject, org.hamcrest.Matcher<String> text) {
        return Matchers.allOf((org.hamcrest.Matcher)Matchers.hasProperty((String)"severity", severity), (org.hamcrest.Matcher)Matchers.hasProperty((String)"subject", subject), (org.hamcrest.Matcher)Matchers.hasProperty((String)"text", text));
    }

    public static <T> Map<String, T> normalizePullRequestData(Map<String, T> in) {
        return RestMigrationHelper.normalizePullRequestData(in, (Set<String>)ImmutableSet.of());
    }

    public static <T> Map<String, T> normalizePullRequestData(String exportVersionId, String importVersionId, Map<String, T> in) {
        return RestMigrationHelper.normalizePullRequestData(in, RestMigrationHelper.getIgnoredProperties(exportVersionId, importVersionId));
    }

    private static Set<String> getIgnoredProperties(String exportVersionId, String importVersionId) {
        ImmutableSet.Builder ignoredKeys = ImmutableSet.builder();
        ignoredKeys.add((Object)"archived").add((Object)"anchor").add((Object)"srcSpanStart").add((Object)"srcSpanEnd").add((Object)"dstSpanStart").add((Object)"dstSpanEnd").add((Object)"multilineStartLine").add((Object)"multilineStartLineType").add((Object)"autoMerge").add((Object)"draft").add((Object)"severity").add((Object)"state").add((Object)"tasks").add((Object)"threadResolved").add((Object)"transitionable").add((Object)"type");
        if ("8.0".equals(exportVersionId) || "8.0".equals(importVersionId)) {
            ignoredKeys.add((Object)"repository").add((Object)"truncated");
        }
        return ignoredKeys.build();
    }

    private static <T> Map<String, T> normalizePullRequestData(Map<String, T> in, Set<String> additionalIgnoredProperties) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object[])new String[]{"id", "repositoryId", "commentIds", "current", "deletable", "editable", "href", "version"});
        builder.addAll(additionalIgnoredProperties);
        ImmutableSet ignoredProperties = builder.build();
        TreeMap out = new TreeMap();
        LinkedList currentIn = new LinkedList();
        currentIn.push(in);
        LinkedList currentOut = new LinkedList();
        currentOut.push(out);
        LinkedList listsToSort = new LinkedList();
        while (!currentIn.isEmpty()) {
            Map<String, Object> filteredMap = ((Map)currentIn.peek()).entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).filter(entry -> !ignoredProperties.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (Objects.equals("SERVICE", filteredMap.get("type"))) {
                String displayName = filteredMap.get("displayName").toString();
                String hashedName = Hashing.sha1().hashString((CharSequence)displayName, StandardCharsets.UTF_8).toString();
                filteredMap.put("name", hashedName);
                filteredMap.put("slug", hashedName);
                filteredMap.remove("active");
            }
            if (filteredMap.get("description") != null) {
                String description = filteredMap.get("description").toString();
                String replacement = ATTACHMENT_PATTERN.matcher(description).replaceAll("$1ID$2");
                filteredMap.put("description", replacement);
            }
            ((Map)currentOut.peek()).putAll(filteredMap);
            currentIn.pop();
            ((Map)currentOut.pop()).entrySet().forEach(e -> {
                Object value = e.getValue();
                if (value instanceof Map) {
                    TreeMap nestedOut = new TreeMap();
                    currentIn.push((Map)value);
                    currentOut.push(nestedOut);
                    e.setValue(nestedOut);
                } else if (value instanceof List) {
                    List list = (List)value;
                    LinkedList tmpList = new LinkedList();
                    for (Object o : list) {
                        if (o instanceof Map) {
                            currentIn.push((Map)o);
                            TreeMap tmpMap = new TreeMap();
                            tmpList.add(tmpMap);
                            currentOut.push(tmpMap);
                            continue;
                        }
                        tmpList.add(o);
                    }
                    if (tmpList.size() > 1) {
                        listsToSort.add(tmpList);
                    }
                    e.setValue(tmpList);
                }
            });
        }
        listsToSort.forEach(list -> list.sort(Comparator.comparing(Object::toString)));
        return out;
    }
}

