/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.test.rest.AbstractRestRequest;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractEnrichableRestRequest
extends AbstractRestRequest {
    private final AvatarRequest avatarRequest;
    private final Boolean markup;

    protected AbstractEnrichableRestRequest(AbstractEnrichableBuilder<?, ?> builder) {
        super(builder);
        this.avatarRequest = builder.avatarRequest;
        this.markup = builder.markup;
    }

    @Nullable
    public AvatarRequest getAvatarRequest() {
        return this.avatarRequest;
    }

    @Nullable
    public Boolean getMarkup() {
        return this.markup;
    }

    @Override
    @Nonnull
    public Map<String, Object> toQueryParams() {
        Map<String, Object> params = super.toQueryParams();
        if (this.avatarRequest != null) {
            params.put("avatarSize", this.avatarRequest.getSize());
            params.put("avatarScheme", this.avatarRequest.isSecure() ? "https" : "http");
        }
        if (this.markup != null) {
            params.put("markup", this.markup);
        }
        return params;
    }

    protected static abstract class AbstractEnrichableBuilder<B extends AbstractEnrichableBuilder<B, R>, R extends AbstractEnrichableRestRequest>
    extends AbstractRestRequest.AbstractBuilder<B, R> {
        private AvatarRequest avatarRequest;
        private Boolean markup;

        protected AbstractEnrichableBuilder() {
        }

        protected AbstractEnrichableBuilder(@Nonnull R request) {
            super(request);
            this.avatarRequest = ((AbstractEnrichableRestRequest)request).getAvatarRequest();
            this.markup = ((AbstractEnrichableRestRequest)request).getMarkup();
        }

        @Nonnull
        public B avatars(boolean secure, int size) {
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"The minimum size for avatars is 1px");
            return this.avatars(new AvatarRequest(secure, size));
        }

        @Nonnull
        public B avatars(@Nullable AvatarRequest value) {
            this.avatarRequest = value;
            return (B)((Object)((AbstractEnrichableBuilder)((Object)this.self())));
        }

        @Nonnull
        public B markup(@Nullable Boolean value) {
            this.markup = value;
            return (B)((Object)((AbstractEnrichableBuilder)((Object)this.self())));
        }
    }
}

