/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessHandler;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

class StringProcessHandler
implements NuProcessHandler {
    private static final int ENCODING_BUFFER_SIZE = 32768;
    private final String commandLine;
    private final StreamDecoder stderr;
    private final StdIn stdin;
    private final StreamDecoder stdout;
    private int exitCode;
    private NuProcess nuProcess;

    StringProcessHandler(@Nonnull String commandLine) {
        this(commandLine, null, StdIn.NONE);
    }

    StringProcessHandler(@Nonnull String commandLine, @Nonnull StdIn stdin) {
        this(commandLine, null, stdin);
    }

    StringProcessHandler(@Nonnull String commandLine, @Nullable Charset charset, @Nonnull StdIn stdin) {
        charset = charset == null ? Charset.defaultCharset() : charset;
        this.commandLine = Objects.requireNonNull(commandLine, "commandLine");
        this.stdin = stdin;
        this.exitCode = -1;
        this.stderr = new StreamDecoder(charset);
        this.stdout = new StreamDecoder(charset);
    }

    @Nonnull
    public String getCommandLine() {
        return this.commandLine;
    }

    @Nonnull
    public String getError() {
        return StringUtils.chomp((String)this.stderr.toString());
    }

    public int getExitCode() {
        return this.exitCode;
    }

    @Nonnull
    public String getOutput() {
        return StringUtils.chomp((String)this.stdout.toString());
    }

    public void onExit(int exitCode) {
        this.exitCode = exitCode;
    }

    public void onPreStart(NuProcess nuProcess) {
        this.nuProcess = nuProcess;
        this.stdout.clear();
        this.stderr.clear();
    }

    public void onStart(NuProcess nuProcess) {
        if (this.stdin != StdIn.NONE) {
            this.nuProcess.wantWrite();
        }
    }

    public void onStderr(ByteBuffer buffer, boolean closed) {
        this.stderr.onBytes(buffer, closed);
        this.nuProcess.closeStdin(true);
    }

    public boolean onStdinReady(ByteBuffer buffer) {
        boolean hasRemaining = buffer.remaining() <= this.stdin.getByteBuffer().remaining();
        buffer.put(this.stdin.getByteBuffer());
        buffer.flip();
        if (!hasRemaining) {
            this.nuProcess.closeStdin(false);
        }
        return hasRemaining;
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        this.stdout.onBytes(buffer, closed);
        this.nuProcess.closeStdin(true);
    }

    public static class StdIn {
        public static final StdIn NONE = new StdIn(ByteBuffer.allocate(0));
        private final ByteBuffer data;

        private StdIn(ByteBuffer data) {
            this.data = data;
        }

        public ByteBuffer getByteBuffer() {
            return this.data;
        }

        public static StdIn fromString(@Nonnull String s) {
            return new StdIn(ByteBuffer.wrap(s.getBytes(Charset.defaultCharset())));
        }
    }

    private static class StreamDecoder {
        private final StringBuilder builder;
        private final CharBuffer chars;
        private final Charset charset;
        private CharsetDecoder decoder;

        StreamDecoder(Charset charset) {
            this.charset = charset;
            this.builder = new StringBuilder();
            this.chars = CharBuffer.allocate(128);
        }

        public String toString() {
            return this.builder.toString();
        }

        void clear() {
            this.builder.setLength(0);
            this.chars.clear();
            this.decoder = null;
        }

        void onBytes(@Nonnull ByteBuffer buffer, boolean closed) {
            CoderResult result;
            if (this.decoder == null) {
                if (closed && !buffer.hasRemaining()) {
                    return;
                }
                if (buffer.remaining() < 32768 && !closed) {
                    return;
                }
                this.decoder = (this.charset == null ? Charset.defaultCharset() : this.charset).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            do {
                result = this.decoder.decode(buffer, this.chars, closed);
                this.chars.flip();
                if (this.chars.hasRemaining()) {
                    this.builder.append(this.chars.array(), this.chars.arrayOffset(), this.chars.remaining());
                }
                this.chars.clear();
            } while (result.isOverflow());
        }
    }
}

