/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import javax.ws.rs.core.Response;

public class PullRequestCommentReactionHelper {
    private final String projectKey;
    private final long pullRequestId;
    private final String repositorySlug;

    public PullRequestCommentReactionHelper(String projectKey, String repositorySlug, long pullRequestId) {
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
        this.pullRequestId = pullRequestId;
    }

    public Response addCommentReaction(long commentId, String emoticonShortcut, String user) {
        return this.addCommentReaction(commentId, emoticonShortcut, user, user);
    }

    public Response addCommentReaction(long commentId, String emoticonShortcut, String username, String password) {
        String url = this.getCommentReactionsURL(commentId, emoticonShortcut);
        return (Response)RestAssured.given().auth().preemptive().basic(username, password).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().put(url, new Object[0]);
    }

    public Response removeCommentReaction(long commentId, String emoticonShortcut, String user) {
        return this.removeCommentReaction(commentId, emoticonShortcut, user, user);
    }

    public Response removeCommentReaction(long commentId, String emoticonShortcut, String username, String password) {
        String url = this.getCommentReactionsURL(commentId, emoticonShortcut);
        return (Response)RestAssured.given().auth().preemptive().basic(username, password).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifError().when().delete(url, new Object[0]);
    }

    public String getCommentReactionsURL(long commentId, String emoticonShortcut) {
        return this.getRepoBaseURL() + "/pull-requests/" + this.pullRequestId + "/comments/" + commentId + "/reactions/" + emoticonShortcut;
    }

    protected String getRepoBaseURL() {
        return DefaultFuncTestData.getRestURL("comment-likes", "latest") + "/projects/" + this.projectKey + "/repos/" + this.repositorySlug;
    }
}

