/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.audit;

import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.AuditTestHelper;
import com.atlassian.bitbucket.test.audit.Audit;
import com.atlassian.bitbucket.test.audit.AuditTestUtils;
import com.atlassian.bitbucket.test.audit.AuditVerifier;
import com.atlassian.bitbucket.test.audit.VerifyAudited;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.restassured.path.json.JsonPath;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditFileVerifier
implements AuditVerifier {
    private static final long AUDIT_LOGGING_TIMEOUT_MILLIS = 10000L;
    private static final Logger log = LoggerFactory.getLogger(AuditFileVerifier.class);
    protected final String baseUrl;
    private Instant startTime;

    public AuditFileVerifier(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void startRecording() {
        this.clearLogFilesContent();
        this.startTime = Instant.now();
    }

    @Override
    public void verify(VerifyAudited verifyAudited) {
        Arrays.asList(verifyAudited.value()).forEach(audit -> AsyncTestUtils.waitFor((WaitCondition)this.logsContain((Audit)audit), (long)10000L, (long)50L));
    }

    private void clearLogFilesContent() {
        AuditTestHelper.clearAuditLogFilesContent(this.baseUrl);
    }

    private List<String> getLogFilesContent() {
        return AuditTestHelper.getAuditLogFilesContent(this.baseUrl);
    }

    private WaitCondition logsContain(Audit audit) {
        final Matcher logMatcher = CoreMatchers.hasItem(this.matchesAuditPattern(audit, this.startTime));
        return new WaitCondition(){
            private List<String> auditLogs;

            public boolean test() {
                this.auditLogs = AuditFileVerifier.this.getLogFilesContent();
                return logMatcher.matches(this.auditLogs);
            }

            public void describeFailure(Description description) {
                description.appendText("\nExpected: ");
                logMatcher.describeTo(description);
                description.appendText("\nActual: ");
                logMatcher.describeMismatch(this.auditLogs, description);
            }
        };
    }

    private TypeSafeMatcher<String> matchesAuditPattern(final Audit audit, final Instant startTime) {
        return new TypeSafeMatcher<String>(){
            private String errorMessage;

            public void describeTo(Description description) {
                description.appendText("an event with attributes: ").appendValue((Object)ImmutableMap.builder().put((Object)"action", (Object)audit.action()).put((Object)"affectedObjects", Arrays.stream(audit.affectedObjects()).map(a -> String.format("{name: %s, type: %s}", a.name(), a.type())).collect(Collectors.toList())).put((Object)"author", (Object)audit.user()).put((Object)"category", (Object)audit.category()).put((Object)"changedValues", Arrays.stream(audit.changedValues()).map(a -> String.format("{key: %s, to: %s, from: %s}", a.key(), a.to(), a.from())).collect(Collectors.toList())).put((Object)"coverageArea", (Object)audit.coverageArea()).put((Object)"coverageLevel", (Object)audit.coverageLevel()).put((Object)"extraAttributes", Arrays.stream(audit.attributes()).map(a -> String.format("{name: %s, value: %s}", a.name(), a.value())).collect(Collectors.toList())).put((Object)"method", (Object)audit.method()).put((Object)"source", (Object)audit.source()).put((Object)"system", (Object)audit.system()).build()).appendText(" and timestamp after " + startTime.getEpochSecond());
            }

            protected void describeMismatchSafely(String item, Description mismatchDescription) {
                String action = JsonPath.from((String)item).getString("auditType.action");
                if (audit.action().equals(action)) {
                    mismatchDescription.appendText("\nPartially matching event: ").appendValue((Object)action);
                    if (this.errorMessage != null) {
                        mismatchDescription.appendText("\nExtra details: ").appendText(this.errorMessage);
                    }
                    mismatchDescription.appendText("\nFull event: ").appendText("\n" + JsonPath.from((String)item).prettify());
                } else {
                    mismatchDescription.appendText("\nEvent with the mismatching action ").appendValue((Object)action);
                }
            }

            protected boolean matchesSafely(String item) {
                int actualSize;
                ArrayList expectedChangedValues;
                ArrayList expectedAttributes;
                ArrayList expectedAffectedObjects;
                JsonPath json = JsonPath.from((String)item);
                String action = Objects.requireNonNull(json.getString("auditType.action"), "auditType.action");
                if (!action.equals(audit.action())) {
                    return false;
                }
                List rawAffectedObjects = Objects.requireNonNull(json.getList("affectedObjects"), "affectedObjects");
                List affectedObjects = rawAffectedObjects.stream().map(AuditTestUtils::buildAffectedObject).collect(Collectors.toList());
                if (!affectedObjects.containsAll(expectedAffectedObjects = Lists.newArrayList((Object[])audit.affectedObjects()))) {
                    expectedAffectedObjects.removeAll(affectedObjects);
                    this.errorMessage = String.format("'affectedObjects' is missing [%s]", StringUtils.join((Iterable)expectedAffectedObjects, (String)", "));
                    return false;
                }
                List rawAttributes = Objects.requireNonNull(json.getList("extraAttributes"), "extraAttributes");
                List attributes = rawAttributes.stream().map(AuditTestUtils::buildAttribute).collect(Collectors.toList());
                if (!attributes.containsAll(expectedAttributes = Lists.newArrayList((Object[])audit.attributes()))) {
                    this.errorMessage = String.format("Expected 'extraAttributes' to contain [%s], but the 'extraAttributes' were [%s]", StringUtils.join((Iterable)expectedAttributes, (String)", "), StringUtils.join(attributes, (String)", "));
                    return false;
                }
                String author = Objects.requireNonNull(json.getString("author.name"), "author.name");
                if (!author.equals(audit.user())) {
                    this.errorMessage = String.format("Expected 'author' [%s] but got [%s]", audit.user(), author);
                    return false;
                }
                String category = Objects.requireNonNull(json.getString("auditType.category"), "auditType.category");
                if (!category.equals(audit.category())) {
                    this.errorMessage = String.format("Expected 'category' [%s] but got [%s]", audit.category(), category);
                    return false;
                }
                List rawChangedValues = Objects.requireNonNull(json.getList("changedValues"), "changedValues");
                List changedValues = rawChangedValues.stream().map(AuditTestUtils::buildChangedValue).collect(Collectors.toList());
                if (!changedValues.containsAll(expectedChangedValues = Lists.newArrayList((Object[])audit.changedValues()))) {
                    this.errorMessage = String.format("Expected 'changedValues' to contain [%s], but the 'changedValues' were [%s]", StringUtils.join((Iterable)expectedChangedValues, (String)", "), StringUtils.join(changedValues, (String)", "));
                    return false;
                }
                CoverageArea coverageArea = CoverageArea.valueOf((String)Objects.requireNonNull(json.getString("auditType.area"), "auditType.area"));
                if (coverageArea != audit.coverageArea()) {
                    this.errorMessage = String.format("Expected 'coverageArea' [%s] but got [%s]", audit.coverageArea(), coverageArea);
                    return false;
                }
                CoverageLevel coverageLevel = CoverageLevel.valueOf((String)Objects.requireNonNull(json.getString("auditType.level"), "auditType.level"));
                if (coverageLevel != audit.coverageLevel()) {
                    this.errorMessage = String.format("Expected 'coverageLevel' [%s] but got [%s]", audit.coverageLevel(), coverageLevel);
                    return false;
                }
                Optional<String> method = Optional.ofNullable(json.getString("method"));
                if (method.map(m -> !m.equals(audit.method())).orElse(false).booleanValue()) {
                    this.errorMessage = String.format("Expected 'method' [%s] but got [%s]", audit.method(), method.get());
                    return false;
                }
                Optional<String> source = Optional.ofNullable(json.getString("source"));
                if (source.map(s -> !s.equals(audit.source()) && !"0:0:0:0:0:0:0:1".equals(s)).orElse(false).booleanValue()) {
                    this.errorMessage = String.format("Expected 'source' [%s] but got [%s]", audit.source(), source.get());
                    return false;
                }
                Optional<String> system = Optional.ofNullable(json.getString("system"));
                if (system.map(s -> !s.equals(audit.system())).orElse(false).booleanValue()) {
                    this.errorMessage = String.format("Expected 'system' [%s] but got [%s]", audit.system(), system.get());
                    return false;
                }
                String version = Objects.requireNonNull(json.getString("version"), "version");
                if (!version.equals(audit.version())) {
                    this.errorMessage = String.format("Expected 'version' [%s] but got [%s]", audit.version(), version);
                    return false;
                }
                if (!this.loggedAfterStartTime(item)) {
                    this.errorMessage = "Event was not logged after the start time";
                    return false;
                }
                if (expectedAffectedObjects.size() < affectedObjects.size()) {
                    actualSize = affectedObjects.size();
                    affectedObjects.removeAll(expectedAffectedObjects);
                    log.warn("The test is only asserting {} 'affectedObjects' but {} have been audited. Missing assertion on 'affectedObjects': [{}]", new Object[]{expectedAffectedObjects.size(), actualSize, StringUtils.join(affectedObjects, (String)", ")});
                }
                if (expectedAttributes.size() < attributes.size()) {
                    actualSize = attributes.size();
                    attributes.removeAll(expectedAttributes);
                    log.warn("The test is only asserting {} 'expectedAttributes' but {} have been audited. Missing assertion on 'expectedAttributes': [{}]", new Object[]{expectedAttributes.size(), actualSize, StringUtils.join(attributes, (String)", ")});
                }
                if (expectedChangedValues.size() < changedValues.size()) {
                    actualSize = changedValues.size();
                    changedValues.removeAll(expectedChangedValues);
                    log.warn("The test is only asserting {} 'changedValues' but {} have been audited. Missing assertion on 'changedValues': [{}]", new Object[]{expectedChangedValues.size(), actualSize, StringUtils.join(changedValues, (String)", ")});
                }
                return true;
            }

            private boolean loggedAfterStartTime(String item) {
                JsonPath json = JsonPath.from((String)item);
                Instant logTime = Instant.ofEpochSecond(json.getLong("timestamp.epochSecond"), json.getLong("timestamp.nano"));
                return logTime.isAfter(startTime);
            }
        };
    }
}

