/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.server.ApplicationState;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ProjectTestHelper;
import com.atlassian.bitbucket.test.RepositoryTestHelper;
import com.atlassian.bitbucket.test.SearchTestHelper;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.atlassian.util.concurrent.ThreadFactories;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class UpgradeTestUtils {
    public static final String BITBUCKET_INIT_SCRIPT = "/etc/init.d/atlbitbucket";
    private static final boolean ADMINISTRATOR_INSTALL = Boolean.parseBoolean(System.getProperty("administrator.install"));
    private static final List<String> SETUP_PROPERTIES = ImmutableList.of((Object)"setup.displayName=Installer test", (Object)"setup.baseUrl=http://localhost:7990/", (Object)"setup.sysadmin.username=admin", (Object)"setup.sysadmin.password=admin", (Object)"setup.sysadmin.displayName=admin", (Object)"setup.sysadmin.emailAddress=admin@exmaple.com", (Object)("jdbc.driver=" + System.getProperty("jdbc.driver")), (Object)("jdbc.url=" + System.getProperty("jdbc.url")), (Object)("jdbc.user=" + System.getProperty("jdbc.user")), (Object)("jdbc.password=" + System.getProperty("jdbc.password")), (Object)("plugin.bitbucket-git.path.executable=" + System.getProperty("plugin.bitbucket-git.path.executable")));
    private static final Logger log = LoggerFactory.getLogger(UpgradeTestUtils.class);

    public static void doBasicSearch(String testProjectKey, String testRepoSlug, String testSearchQuery) {
        SearchTestHelper.waitForSearch();
        SearchTestHelper.waitForIndexing(() -> SearchTestHelper.getRepositoryCount(testProjectKey) == 1, "The repository was not indexed");
        SearchTestHelper.waitForIndexing(() -> SearchTestHelper.assertCodeSearchCount(testSearchQuery, 2), "The repository's code was not indexed");
        Response response = (Response)((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body(SearchTestHelper.codeSearchFor(testSearchQuery)).when().post(SearchTestHelper.getCodeSearchRestUrl(), new Object[0]);
        JsonPath jsonPath = response.getBody().jsonPath();
        MatcherAssert.assertThat((Object)jsonPath.getString("scope.repository.project.key"), (Matcher)Matchers.equalTo((Object)testProjectKey));
        MatcherAssert.assertThat((Object)jsonPath.getString("scope.repository.slug"), (Matcher)Matchers.equalTo((Object)testRepoSlug));
        MatcherAssert.assertThat((Object)jsonPath.getInt("code.count"), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)jsonPath.getString("code.values[0].pathMatches[0].text"), (Matcher)Matchers.equalTo((Object)"symlink"));
        MatcherAssert.assertThat((Object)jsonPath.getString("code.values[0].pathMatches[0].match"), (Matcher)Matchers.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)jsonPath.getString("code.values[1].pathMatches[0].text"), (Matcher)Matchers.equalTo((Object)"symlink"));
        MatcherAssert.assertThat((Object)jsonPath.getString("code.values[1].pathMatches[0].match"), (Matcher)Matchers.equalTo((Object)"true"));
        List hitContexts = jsonPath.getList("code.values[0].hitContexts");
        if (hitContexts.isEmpty()) {
            hitContexts = jsonPath.getList("code.values[1].hitContexts");
        }
        MatcherAssert.assertThat((Object)((String)((Map)((List)hitContexts.get(0)).get(0)).get("text")), (Matcher)Matchers.containsString((String)"<em>symlink</em>"));
    }

    public static List<String> getSetupProperties(String license) {
        return new ImmutableList.Builder().addAll(SETUP_PROPERTIES).add((Object)("setup.license=" + license.replaceAll("\n", ""))).build();
    }

    public static boolean maybeRunWithSudo(String ... command) throws Exception {
        if (ADMINISTRATOR_INSTALL) {
            log.info("Running `{}` as sudo", (Object)String.join((CharSequence)" ", command));
            ArrayList<String> sudoCommand = new ArrayList<String>();
            sudoCommand.add("sudo");
            sudoCommand.addAll(Arrays.asList(command));
            return UpgradeTestUtils.runCommand(sudoCommand.toArray(new String[0]));
        }
        log.info("Running: `{}` as the current user", (Object)String.join((CharSequence)" ", command));
        return UpgradeTestUtils.runCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runCommand(String ... command) throws Exception {
        String commandString = String.join((CharSequence)" ", command);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(command);
        log.info("Running command `{}`", (Object)commandString);
        ExecutorService executor = Executors.newFixedThreadPool(2, ThreadFactories.namedThreadFactory((String)"process-log", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
        try {
            Process process = processBuilder.start();
            executor.submit(() -> UpgradeTestUtils.logCommandOutput(process.getInputStream(), "[STDOUT]", (arg_0, arg_1) -> ((Logger)log).info(arg_0, arg_1)));
            executor.submit(() -> UpgradeTestUtils.logCommandOutput(process.getErrorStream(), "[STDERR]", (arg_0, arg_1) -> ((Logger)log).error(arg_0, arg_1)));
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                log.info("Exit code `{}`: {}", (Object)commandString, (Object)exitCode);
            } else {
                log.error("Exit code `{}`: {}", (Object)commandString, (Object)exitCode);
            }
            boolean bl = exitCode == 0;
            return bl;
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static boolean runInstaller(String installer, Map<String, String> responseFileVariables) throws Exception {
        Path responseFile = Files.createTempFile("response", ".varfile", new FileAttribute[0]);
        UpgradeTestUtils.writePropertiesFile(responseFile, responseFileVariables);
        return UpgradeTestUtils.maybeRunWithSudo(installer, "-q", "-Dinstall4j.debug=true", "-Dinstall4j.logToStderr=true", "-Dinstall4j.keepLog=true", "-varfile", responseFile.toString());
    }

    public static void setupRepo(String testProjectKey, String testRepoSlug, String bitbucketUrl, TemporaryFolder tmpFolder) throws Exception {
        if (ProjectTestHelper.getProject(testProjectKey).getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
            ProjectTestHelper.createProject(testProjectKey, testProjectKey, testProjectKey);
            RepositoryTestHelper.createRepository(testProjectKey, testRepoSlug);
            ClassPathResource repositoryResource = new ClassPathResource("git/default-repository.zip");
            RepositoryTestHelper.pushRep(tmpFolder, bitbucketUrl, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), testProjectKey, testRepoSlug, (Resource)repositoryResource);
        }
    }

    public static void stopService() throws Exception {
        Assert.assertTrue((String)"Failed to stop the Bitbucket service", (boolean)UpgradeTestUtils.maybeRunWithSudo(BITBUCKET_INIT_SCRIPT, "stop"));
    }

    public static void waitForApplicationStartup(final ApplicationState expectedState) {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){
            private String lastState;

            public void describeFailure(Description description) throws Exception {
                description.appendText("Expected startup to succeed. Last state was '" + this.lastState);
            }

            public boolean test() throws Exception {
                this.lastState = UpgradeTestUtils.getApplicationState();
                return expectedState.name().equals(this.lastState);
            }
        }, (long)TimeUnit.SECONDS.toMillis(300L), (long)TimeUnit.SECONDS.toMillis(5L));
    }

    public static void writePropertiesFile(Path location, Map<String, String> mappings) throws IOException {
        Properties properties = new Properties();
        properties.putAll(mappings);
        properties.store(Files.newBufferedWriter(location, new OpenOption[0]), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getApplicationState() {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            HttpGet req = new HttpGet("http://localhost:7990/status");
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)req);){
                String rawJson = EntityUtils.toString((HttpEntity)response.getEntity());
                JsonElement jsonElement = new JsonParser().parse(rawJson);
                if (!jsonElement.isJsonObject()) return null;
                JsonElement state = jsonElement.getAsJsonObject().get("state");
                String string = state.getAsString();
                return string;
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to retrieve application state", (Throwable)e);
                return null;
            }
            log.info("Failed to retrieve application state");
        }
        return null;
    }

    private static void logCommandOutput(InputStream commandOutputStream, String logLinePrefix, BiConsumer<String, Object> logger) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(commandOutputStream, StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                logger.accept(logLinePrefix + " {}", line);
            }
        }
        catch (IOException e) {
            log.error("Failed reading log output", (Throwable)e);
        }
    }
}

