/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.stash.internal.build.requiredbuilds.rest.RestRequiredBuildCondition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;

public class RequiredBuildsTestHelper {
    private final String password;
    private final String projectKey;
    private final String repoSlug;
    private final String username;

    public RequiredBuildsTestHelper(String username, String password, String projectKey, String repoSlug) {
        this.username = username;
        this.password = password;
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public RestRequiredBuildCondition create(List<String> buildParentKeys, RefMatcherType destinationRefMatcherType, String destinationId, RefMatcherType exemptRefMatcherType, String exemptId) {
        return this.create(this.createRequest(buildParentKeys, destinationRefMatcherType, destinationId, exemptRefMatcherType, exemptId), 200);
    }

    public RestRequiredBuildCondition create(JSONObject request, int expectedStatus) {
        return this.create(request, this.username, this.password, expectedStatus);
    }

    public RestRequiredBuildCondition create(JSONObject request, String username, String password, int expectedStatus) {
        return (RestRequiredBuildCondition)((Response)RestAssured.given().auth().preemptive().basic(username, password).contentType("application/json").body(request.toString()).expect().statusCode(expectedStatus).when().post(this.getRequiredBuildsRestUrl() + "/condition", new Object[0])).getBody().as(RestRequiredBuildCondition.class);
    }

    public void createExampleConfigs() {
        this.create((List<String>)ImmutableList.of((Object)"STAGING-key"), RefMatcherType.BRANCH_NAME, "basic_branching", RefMatcherType.MODEL_CATEGORY, "HOTFIX");
        this.create((List<String>)ImmutableList.of((Object)"Bamboo-key", (Object)"Compat-builds-key"), RefMatcherType.BRANCH_PATTERN, "pattern/**/fixes/**", RefMatcherType.MODEL_BRANCH, "DEVELOPMENT");
        this.create((List<String>)ImmutableList.of((Object)"Bamboo-key", (Object)"Compat-builds-key"), RefMatcherType.MODEL_CATEGORY, "BUGFIX", null, null);
        this.create((List<String>)ImmutableList.of((Object)"Jenkins-key", (Object)"PROD-key", (Object)"Plugin-enables-key"), RefMatcherType.ANY_BRANCH, "ANY_REF_ID", RefMatcherType.BRANCH_PATTERN, "pattern/**/fixes/**");
        this.create((List<String>)ImmutableList.of((Object)"Development-key"), RefMatcherType.ANY_BRANCH, "ANY_REF_ID", RefMatcherType.MODEL_BRANCH, "development");
    }

    public JSONObject createRequest(List<String> buildParentKeys, RefMatcherType destinationRefMatcherType, String destinationId, RefMatcherType exemptRefMatcherType, String exemptId) {
        JSONObject request = new JSONObject();
        request.put((Object)"buildParentKeys", buildParentKeys);
        request.put((Object)"refMatcher", RequiredBuildsTestHelper.createRefJson(destinationRefMatcherType, destinationId));
        if (exemptRefMatcherType == null && exemptId == null) {
            request.put((Object)"exemptRefMatcher", null);
        } else {
            request.put((Object)"exemptRefMatcher", RequiredBuildsTestHelper.createRefJson(exemptRefMatcherType, exemptId));
        }
        return request;
    }

    public void delete(long conditionId, int expectedStatus) {
        this.delete(conditionId, this.username, this.password, expectedStatus);
    }

    public void delete(long conditionId, String user, String password, int expectedStatus) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).expect().log().ifValidationFails()).statusCode(expectedStatus).when().delete(this.getRequiredBuildsRestUrl() + "/condition/" + conditionId, new Object[0]);
    }

    public List<RestRequiredBuildCondition> get(int expectedStatus) {
        return this.get(this.username, this.password, expectedStatus);
    }

    public List<RestRequiredBuildCondition> get(String user, String password, int expectedStatus) {
        RestRequiredBuildCondition[] results = (RestRequiredBuildCondition[])((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).expect().log().ifValidationFails()).statusCode(expectedStatus).when().get(this.getRequiredBuildsRestUrl() + "/conditions", new Object[0])).getBody().jsonPath().getObject("values", RestRequiredBuildCondition[].class);
        if (results == null) {
            return null;
        }
        return Arrays.stream(results).collect(Collectors.toList());
    }

    public RestRequiredBuildCondition update(long conditionId, List<String> buildParentKeys, RefMatcherType destinationRefMatcherType, String destinationId, RefMatcherType exemptRefMatcherType, String exemptId) {
        return this.update(conditionId, this.createRequest(buildParentKeys, destinationRefMatcherType, destinationId, exemptRefMatcherType, exemptId), 200);
    }

    public RestRequiredBuildCondition update(long conditionId, JSONObject request, int expectedStatus) {
        return this.update(conditionId, request, this.username, this.password, expectedStatus);
    }

    public RestRequiredBuildCondition update(long conditionId, JSONObject request, String username, String password, int expectedStatus) {
        return (RestRequiredBuildCondition)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(username, password).contentType(ContentType.JSON).body(request.toString()).expect().log().ifValidationFails()).statusCode(expectedStatus).when().put(this.getRequiredBuildsRestUrl() + "/condition/" + conditionId, new Object[0])).getBody().as(RestRequiredBuildCondition.class);
    }

    private static ImmutableMap<String, Object> createRefJson(RefMatcherType type, String id) {
        return ImmutableMap.of((Object)"id", (Object)id, (Object)"type", (Object)ImmutableMap.of((Object)"id", (Object)type.getId()));
    }

    private String getRequiredBuildsRestUrl() {
        return DefaultFuncTestData.getRestURL("required-builds", "latest") + "/projects/" + this.projectKey + "/repos/" + this.repoSlug;
    }

    public static enum RefMatcherType {
        ANY_BRANCH("ANY_REF"),
        BRANCH_PATTERN("PATTERN"),
        BRANCH_NAME("BRANCH"),
        MODEL_BRANCH("MODEL_BRANCH"),
        MODEL_CATEGORY("MODEL_CATEGORY"),
        INVALID("INVALID_MATCHER");

        private String id;

        private RefMatcherType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

