/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class FeatureTestHelper {
    private static final String ADMIN_PASSWORD = DefaultFuncTestData.getAdminPassword();
    private static final String ADMIN_USER = DefaultFuncTestData.getAdminUser();

    private FeatureTestHelper() {
    }

    public static boolean isEnabled(@Nonnull StandardFeature feature) {
        return (Boolean)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(ADMIN_USER, ADMIN_PASSWORD).contentType("application/json").when().get(FeatureTestHelper.getFeatureUrl(), new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).log().ifValidationFails()).extract().jsonPath().get("'" + feature.getKey() + "'");
    }

    public static void setFeature(@Nonnull StandardFeature feature, boolean enabled) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(ADMIN_USER, ADMIN_PASSWORD).queryParam("feature", new Object[]{feature.getKey()}).queryParam("enabled", new Object[]{enabled}).contentType("application/json").when().post(FeatureTestHelper.getFeatureUrl(), new Object[0])).then()).statusCode(Response.Status.NO_CONTENT.getStatusCode())).log().ifValidationFails();
    }

    private static String getFeatureUrl() {
        return DefaultFuncTestData.getRestURL("standard-feature", "latest") + "/feature";
    }
}

