/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class DefaultTasksTestHelper {
    private final String url;

    public DefaultTasksTestHelper(String projectKey) {
        this.url = DefaultFuncTestData.getProjectRestURL("default-tasks", "latest", projectKey) + "/tasks";
    }

    public DefaultTasksTestHelper(String projectKey, String repoSlug) {
        this.url = DefaultFuncTestData.getRepositoryRestURL("default-tasks", "latest", projectKey, repoSlug) + "/tasks";
    }

    public static JSONObject getRestDefaultTask(String description) {
        return DefaultTasksTestHelper.getRestDefaultTask(description, "ANY_REF", "any", "ANY_REF", "any");
    }

    public static JSONObject getRestDefaultTask(String description, String sourceType, String sourceValue, String targetType, String targetValue) {
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"sourceMatcher", (Object)ImmutableMap.of((Object)"id", (Object)sourceValue, (Object)"type", (Object)ImmutableMap.of((Object)"id", (Object)sourceType)));
        requestBody.put((Object)"targetMatcher", (Object)ImmutableMap.of((Object)"id", (Object)targetValue, (Object)"type", (Object)ImmutableMap.of((Object)"id", (Object)targetType)));
        requestBody.put((Object)"description", (Object)description);
        return requestBody;
    }

    public Response createDefaultTask(JSONObject request, String user, int statusCode) {
        return (Response)RestAssured.given().auth().preemptive().basic(user, user).contentType("application/json").body(request.toString()).expect().statusCode(statusCode).when().post(this.url, new Object[0]);
    }

    public void createDefaultTask(String user, String description) {
        this.createDefaultTask(DefaultTasksTestHelper.getRestDefaultTask(description), user, Response.Status.OK.getStatusCode());
    }

    public List<JSONObject> createDefaultTasks(int numTasks, String user) {
        List<JSONObject> requests = IntStream.range(0, numTasks).mapToObj(i -> DefaultTasksTestHelper.getRestDefaultTask("task" + UUID.randomUUID())).collect(Collectors.toList());
        requests.forEach(request -> this.createDefaultTask((JSONObject)request, user, Response.Status.OK.getStatusCode()));
        return requests;
    }

    public void deleteTaskById(int taskId, String user, int statusCode) {
        RestAssured.given().auth().preemptive().basic(user, user).expect().statusCode(statusCode).when().delete(this.url + "/" + taskId, new Object[0]);
    }

    public void deleteTasksByScope(String user) {
        this.deleteTasksByScope(user, Response.Status.NO_CONTENT.getStatusCode());
    }

    public void deleteTasksByScope(String user, int statusCode) {
        RestAssured.given().auth().preemptive().basic(user, user).expect().statusCode(statusCode).when().delete(this.url, new Object[0]);
    }

    public void getDefaultTasks(String user, int statusCode) {
        RestAssured.given().auth().preemptive().basic(user, user).expect().statusCode(statusCode).when().get(this.url, new Object[0]);
    }

    public List<Map<String, Object>> getDefaultTasks(String user) {
        return ((Response)RestAssured.given().auth().preemptive().basic(user, user).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.url, new Object[0])).getBody().jsonPath().getList("values");
    }

    public List<Map<String, Object>> getDefaultTasksWithMarkup(String user) {
        return ((Response)RestAssured.given().auth().preemptive().basic(user, user).param("markup", new Object[]{true}).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.url, new Object[0])).getBody().jsonPath().getList("values");
    }

    public void updateTask(JSONObject request, int taskId, String user, int statusCode) {
        RestAssured.given().auth().preemptive().basic(user, user).contentType("application/json").body(request.toString()).expect().statusCode(statusCode).when().put(this.url + "/" + taskId, new Object[0]);
    }
}

