/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.runners;

import com.atlassian.bitbucket.test.runners.ConditionalRunner;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import java.util.zip.CRC32;
import org.junit.runner.notification.RunNotifier;

public class FuncTestSplitterRunner
extends ConditionalRunner {
    private final Integer bucket;
    private final Integer buckets = Integer.getInteger("stash.test.func.buckets", 1);
    private final HashingAlgorithms hashingAlgorithm;
    private final String suffix;

    public FuncTestSplitterRunner(Class<?> klass) throws Throwable {
        super(klass);
        this.bucket = Integer.getInteger("stash.test.func.bucket", 0);
        this.suffix = System.getProperty("stash.test.func.suffix", "");
        this.hashingAlgorithm = HashingAlgorithms.valueOf(System.getProperty("stash.test.func.hash", HashingAlgorithms.JAVA.name()));
    }

    @Override
    public void run(RunNotifier notifier) {
        String className = this.getTestClass().getName();
        int thisBucket = this.hashingAlgorithm.hashingFunction.apply(className + this.suffix, this.buckets);
        if (thisBucket == this.bucket) {
            super.run(notifier);
        }
    }

    static enum HashingAlgorithms {
        JAVA((s, mod) -> Math.abs(s.hashCode() % mod)),
        CRC32((s, mod) -> {
            CRC32 crc32 = new CRC32();
            crc32.update(s.getBytes(StandardCharsets.UTF_8));
            return (int)Math.abs(crc32.getValue() % (long)mod.intValue());
        });

        final BiFunction<String, Integer, Integer> hashingFunction;

        private HashingAlgorithms(BiFunction<String, Integer, Integer> hashingFunction) {
            this.hashingFunction = hashingFunction;
        }
    }
}

