/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.project;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.project.RestProjectRequest;
import io.restassured.path.json.JsonPath;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestProjectHelper
extends AbstractRestHelper {
    private final String projectKey;

    public RestProjectHelper(@Nonnull String projectKey) {
        this(DefaultFuncTestData.getAdminAuthentication(), projectKey);
    }

    public RestProjectHelper(@Nullable RestAuthentication defaultAuthentication, @Nonnull String projectKey) {
        super(defaultAuthentication);
        this.projectKey = Objects.requireNonNull(projectKey, "projectKey");
    }

    @Nonnull
    public JsonPath get() {
        return this.get(new RestProjectRequest.Builder().build());
    }

    @Nonnull
    public JsonPath get(@Nonnull RestProjectRequest request) {
        return this.get(this.getUrl(request), request);
    }

    @Nonnull
    public String getUrl(@Nonnull RestProjectRequest request) {
        return RestTestHelper.buildUrl(DefaultFuncTestData.getProjectRestURL(this.projectKey), request);
    }
}

